using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("industry")]
[Index("Name", Name = "uk_industry", IsUnique = true)]
public partial class Industry
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [Column("description", TypeName = "citext")]
    public string Description { get; set; } = null!;

    [InverseProperty("Industry")]
    public virtual ICollection<Counterparty> Counterparties { get; set; } = new List<Counterparty>();
}
