using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("favorite")]
public partial class Favorite
{
    [Key]
    [Column("user_id")]
    public int UserId { get; set; }

    [Column("screen_ids", TypeName = "citext")]
    public string ScreenIds { get; set; } = null!;

    [ForeignKey("UserId")]
    [InverseProperty("Favorite")]
    public virtual AppUser User { get; set; } = null!;
}
