using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("duns_number")]
[Index("EntityId", Name = "ix_duns_number")]
public partial class DunsNumber
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("entity_id")]
    public int EntityId { get; set; }

    [Column("duns", TypeName = "citext")]
    public string Duns { get; set; } = null!;

    [InverseProperty("Duns")]
    public virtual ICollection<CrudeSupply> CrudeSupplies { get; set; } = new List<CrudeSupply>();

    [ForeignKey("EntityId")]
    [InverseProperty("DunsNumbers")]
    public virtual Counterparty Entity { get; set; } = null!;

    [InverseProperty("Duns")]
    public virtual ICollection<GasSupply> GasSupplies { get; set; } = new List<GasSupply>();
}
