using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("deal_volume")]
[Index("DealId", "StartDate", "PhysicalVolume", Name = "ix_deal_volume")]
[Index("DealId", "StartDate", Name = "uk_deal_volume", IsUnique = true)]
public partial class DealVolume
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("deal_id")]
    public int DealId { get; set; }

    [Column("physical_volume")]
    public double? PhysicalVolume { get; set; }

    [Column("financial_volume")]
    public double? FinancialVolume { get; set; }

    [Column("actual_volume")]
    public double? ActualVolume { get; set; }

    [Column("start_date")]
    public DateOnly StartDate { get; set; }

    [Column("end_date")]
    public DateOnly EndDate { get; set; }

    [ForeignKey("DealId")]
    [InverseProperty("DealVolumes")]
    public virtual Deal Deal { get; set; } = null!;
}
