using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("currency_type")]
public partial class CurrencyType
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string? Name { get; set; }

    [Column("synonym", TypeName = "citext")]
    public string? Synonym { get; set; }

    [Column("is_active")]
    public bool? IsActive { get; set; }

    [Column("symbol", TypeName = "citext")]
    public string? Symbol { get; set; }

    [InverseProperty("CurrencyType")]
    public virtual ICollection<UnitPriceCombination> UnitPriceCombinations { get; set; } = new List<UnitPriceCombination>();
}
