using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("counterparty_duns")]
[Index("CounterpartyId", "Duns", Name = "uk_counterparty_duns", IsUnique = true)]
public partial class CounterpartyDun
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("counterparty_id")]
    public int CounterpartyId { get; set; }

    [Column("duns", TypeName = "citext")]
    public string Duns { get; set; } = null!;

    [ForeignKey("CounterpartyId")]
    [InverseProperty("CounterpartyDuns")]
    public virtual Counterparty Counterparty { get; set; } = null!;
}
