using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("contract_exhibit_c")]
[Index("ContractId", Name = "uk_contract_exhibit_c", IsUnique = true)]
public partial class ContractExhibitC
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("contract_id")]
    public int ContractId { get; set; }

    [Column("bank_name", TypeName = "citext")]
    public string? BankName { get; set; }

    [Column("city_state", TypeName = "citext")]
    public string? CityState { get; set; }

    [Column("aba_num_wire", TypeName = "citext")]
    public string? AbaNumWire { get; set; }

    [Column("aba_num_ach", TypeName = "citext")]
    public string? AbaNumAch { get; set; }

    [Column("account_name", TypeName = "citext")]
    public string? AccountName { get; set; }

    [Column("for_further_credit_to", TypeName = "citext")]
    public string? ForFurtherCreditTo { get; set; }

    [Column("credit_name", TypeName = "citext")]
    public string? CreditName { get; set; }

    [Column("account_num", TypeName = "citext")]
    public string? AccountNum { get; set; }

    [Column("alt1_bank_name", TypeName = "citext")]
    public string? Alt1BankName { get; set; }

    [Column("alt1_city_state", TypeName = "citext")]
    public string? Alt1CityState { get; set; }

    [Column("alt1_aba_num_wire", TypeName = "citext")]
    public string? Alt1AbaNumWire { get; set; }

    [Column("alt1_aba_num_ach", TypeName = "citext")]
    public string? Alt1AbaNumAch { get; set; }

    [Column("alt1_account_name", TypeName = "citext")]
    public string? Alt1AccountName { get; set; }

    [Column("alt1_for_further_credit_to", TypeName = "citext")]
    public string? Alt1ForFurtherCreditTo { get; set; }

    [Column("alt1_credit_name", TypeName = "citext")]
    public string? Alt1CreditName { get; set; }

    [Column("alt1_account_num", TypeName = "citext")]
    public string? Alt1AccountNum { get; set; }

    [Column("alt2_bank_name", TypeName = "citext")]
    public string? Alt2BankName { get; set; }

    [Column("alt2_city_state", TypeName = "citext")]
    public string? Alt2CityState { get; set; }

    [Column("alt2_aba_num_wire", TypeName = "citext")]
    public string? Alt2AbaNumWire { get; set; }

    [Column("alt2_aba_num_ach", TypeName = "citext")]
    public string? Alt2AbaNumAch { get; set; }

    [Column("alt2_account_name", TypeName = "citext")]
    public string? Alt2AccountName { get; set; }

    [Column("alt2_for_further_credit_to", TypeName = "citext")]
    public string? Alt2ForFurtherCreditTo { get; set; }

    [Column("alt2_credit_name", TypeName = "citext")]
    public string? Alt2CreditName { get; set; }

    [Column("alt2_account_num", TypeName = "citext")]
    public string? Alt2AccountNum { get; set; }

    [Column("check_payment_address_line1", TypeName = "citext")]
    public string? CheckPaymentAddressLine1 { get; set; }

    [Column("check_payment_address_line2", TypeName = "citext")]
    public string? CheckPaymentAddressLine2 { get; set; }

    [Column("check_payment_city", TypeName = "citext")]
    public string? CheckPaymentCity { get; set; }

    [Column("check_payment_zip", TypeName = "citext")]
    public string? CheckPaymentZip { get; set; }

    [Column("check_payment_country_id")]
    public int CheckPaymentCountryId { get; set; }

    [Column("check_payment_state_id")]
    public int? CheckPaymentStateId { get; set; }

    [Column("amendment_date")]
    public DateOnly? AmendmentDate { get; set; }

    [ForeignKey("CheckPaymentCountryId")]
    [InverseProperty("ContractExhibitCs")]
    public virtual Country CheckPaymentCountry { get; set; } = null!;

    [ForeignKey("CheckPaymentStateId")]
    [InverseProperty("ContractExhibitCs")]
    public virtual Territory? CheckPaymentState { get; set; }

    [ForeignKey("ContractId")]
    [InverseProperty("ContractExhibitC")]
    public virtual Contract Contract { get; set; } = null!;
}
