using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("contact_counterparty")]
[Index("ContactId", "CounterpartyId", "InactiveDate", Name = "uk_contact_counterparties", IsUnique = true)]
public partial class ContactCounterparty
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("contact_id")]
    public int ContactId { get; set; }

    [Column("counterparty_id")]
    public int CounterpartyId { get; set; }

    [Column("inactive_date")]
    public DateOnly? InactiveDate { get; set; }

    [ForeignKey("ContactId")]
    [InverseProperty("ContactCounterparties")]
    public virtual Contact Contact { get; set; } = null!;

    [ForeignKey("CounterpartyId")]
    [InverseProperty("ContactCounterparties")]
    public virtual Counterparty Counterparty { get; set; } = null!;
}
