using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("book_to_trader")]
public partial class BookToTrader
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("book_id")]
    public int BookId { get; set; }

    [Column("trader_id")]
    public int TraderId { get; set; }

    [ForeignKey("BookId")]
    [InverseProperty("BookToTraders")]
    public virtual Book Book { get; set; } = null!;

    [ForeignKey("TraderId")]
    [InverseProperty("BookToTraders")]
    public virtual AppUser Trader { get; set; } = null!;
}
