using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Shared.Database.Models;

[Table("book")]
[Index("Name", Name = "uk_book_index", IsUnique = true)]
public partial class Book
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string? Name { get; set; }

    [Column("is_active")]
    public bool IsActive { get; set; }

    [InverseProperty("Book")]
    public virtual ICollection<BookToTrader> BookToTraders { get; set; } = new List<BookToTrader>();

    [InverseProperty("Book")]
    public virtual ICollection<Deal> Deals { get; set; } = new List<Deal>();
}
