using Fast.Web.Controllers;
using Microsoft.OData.Edm;
using Microsoft.OData.ModelBuilder;

Fast.Shared.ProgramShared.CustomEdmModel = Helper.GetCustomEdmModel();
Fast.Shared.ProgramShared.Configure(args, Type.GetType("Fast.Web.Logic.JobsHelper"));
await Fast.Shared.ProgramShared.RunAsync();

namespace Fast.Web
{
    public static class Helper
    {
        public static IEdmModel GetCustomEdmModel()
        {
            var builder = new ODataConventionModelBuilder();

            builder.Function("GetBookItems").Returns<BookListItem>();
            builder.Function("GetStrategyItems").Returns<StrategyListItem>();
            builder.Function("GetStorageFacilityItems").Returns<StorageFacilityListItem>();
            builder.Function("GetForceMajeureItems").Returns<ForceMajeureListItem>();
            builder.Function("GetNotificationItems").Returns<NotificationListItem>();
            builder.Function("GetZoneItems").Returns<ZoneListItem>();
            builder.Function("GetPointItems").Returns<PointListItem>();
            builder.Function("GetPortfolioItems").Returns<PortfolioListItem>();
            builder.Function("GetTransferMeterItems").Returns<TransferMeterListItem>();
            builder.Function("GetReceiptDeliveryItems").Returns<ReceiptDeliveryListItem>();
            builder.Function("GetPipelineItems").Returns<PipelineListItem>();
            builder.Function("GetBrokerItems").Returns<BrokerListItem>();
            builder.Function("GetCountyItems").Returns<CountyListItem>();
            builder.Function("GetHolidayItems").Returns<HolidayListItem>();
            builder.Function("GetLocation").Returns<LocationModel>();
            builder.Function("GetLeaseItems").Returns<LeaseListItem>();
            builder.Function("GetMeterTypeItems").Returns<MeterTypeListItem>();
            builder.Function("GetMeterItems").Returns<MeterListItem>();
            builder.Function("GetTemplateItems").Returns<TemplateListItem>();

            // builder.Function("GetSomeItems").Returns<SomeItem>();

            return builder.GetEdmModel();
        }
    }
}
