using System.ComponentModel.DataAnnotations;

namespace Fast.Models;

public class MeterProductListItem
{
    [Key] // Primary Key
    public int Id { get; set; }
    public int MeterId { get; set; }
    public int ProductId { get; set; }
    [Display(Name = "Meter Type")] public string? MeterType { get; set; }
    [Display(Name = "Product Name")] public string? Product { get; set; }
    [Display(Name = "Meter Number")] public string? Number { get; set; } = null!;
    [Display(Name = "Hub Code")] public string? HubCode { get; set; } = null!;
    [Display(Name = "Upstream")] public string? IsUpstream { get; set; }
    [Display(Name = "Source Pipe")] public string? SourcePipe { get; set; }
    [Display(Name = "Source Zone")] public string? SourceZone { get; set; }
    [Display(Name = "Source Points")] public string? SourcePointIds { get; set; }
    [Display(Name = "Delivery Points")] public string? DeliveryPointIds { get; set; }
    [Display(Name = "Plants")] public string? PlantIds { get; set; }
    [Display(Name = "Description")] public string? Description { get; set; } = null!;
    [Display(Name = "Effective Date")] public string? EffectiveDate { get; set; } = null;
}
