using System.ComponentModel.DataAnnotations;
namespace Fast.Models;

public class MeterListItem
{
  [Key]
  public int MeterId { get; set; }
  [Display(Name = "Meter Name")] public string Name { get; set; } = "";
  [Display(Name = "InactiveDate")] public DateOnly? InactiveDate { get; set; }
  [Display(Name = "Producers")] public string? ProducerIds { get; set; }
  [Display(Name = "Lease")] public string? Lease { get; set; } = "";
  [Display(Name = "State")] public string? State { get; set; }
  [Display(Name = "Location")] public string? Location { get; set; }
  [Display(Name = "Latitude")] public decimal? Latitude { get; set; } = 0;
  [Display(Name = "Longitude")] public decimal? Longitude { get; set; } = 0;
  [Display(Name = "Meter Numbers")] public string? Numbers { get; set; } = "";
  [Display(Name = "Source Pipes")] public string? Pipelines { get; set; }
  [Display(Name = "Source Points")] public string? SourcePointNames { get; set; }
  [Display(Name = "Delivery Points")] public string? DeliveryPointNames { get; set; }
  [Display(Name = "Hub Codes")] public string? HubCodes { get; set; } = "";
  [Display(Name = "Meter Types")] public string? MeterTypes { get; set; }
}
