﻿using System.ComponentModel.DataAnnotations;

namespace Fast.Models
{
    public class BrokerListItem
    {
        [Key] //need to set primary key for OData
        public int BrokerId { get; set; }

        [Display(Name = "Broker Name")] public string BrokerName { get; set; } = "";
        [Display(Name = "Broker Type")] public string BrokerType { get; set; } = "";
        [Display(Name = "Broker Accounts")] public string BrokerAccounts { get; set; } = "";
        [Display(Name = "Commission per Contract")] public double? CommissionPerContract { get; set; }
        [Display(Name = "Commission after Hours")] public double? CommissionAfterHours { get; set; }
        [Display(Name = "Commission for EFS")] public double? CommissionForEFS { get; set; }
        [Display(Name = "Memo")] public string Memo { get; set; } = "";
    }
}