﻿namespace Fast.Web.Controllers
{
    [Authorize]
    [ApiController]
    [Route("api/[controller]")]
    public class SystemSettingsController : ODataController
    {
        private readonly MyDbContext db;
        private readonly AuthorizationHelper authHelper;

        public SystemSettingsController(MyDbContext context)
        {
            db = context;
            authHelper = new AuthorizationHelper(Main.IsAuthenticationEnabled);
        }

        [Permission("System Settings", PermissionType.View)]
        [Route("[action]")]
        public async Task<IActionResult> GetRequiredData()
        {
            var hasModifyPermission = await authHelper.IsAuthorizedAsync(User, "System Settings", PermissionType.Modify);

            var result = new { hasModifyPermission };
            return Ok(result);
        }

        [Permission("System Settings", PermissionType.View)]
        [Route("[action]")]
        public async Task<IActionResult> GetDetail()
        {
            var settings = new SystemSettingsDetail
            {
                sqlTimeout = int.Parse((await db.AppSettings.Where(x => x.Name == "SQLTimeOut").FirstAsync()).Value),
                timeLag = int.Parse((await db.AppSettings.Where(x => x.Name == "DealModifyTimeLag").FirstAsync()).Value ?? "0"),
                dealsToLoad = int.Parse((await db.AppSettings.Where(x => x.Name == "DealCount").FirstAsync()).Value),
                useOrigDate = (await db.AppSettings.Where(x => x.Name == "UseOriginalDateForSaveAsNewDeal").FirstAsync()).Value != "0",
                execMargin = decimal.Parse((await db.AppSettings.Where(x => x.Name == "DefaultExecutionMargin").FirstAsync()).Value),
                extraLog = (await db.AppSettings.Where(x => x.Name == "ExtraLogging").FirstAsync()).Value != "0",
                cmeFileCount = int.Parse((await db.AppSettings.Where(x => x.Name == "CmeFileCount").FirstAsync()).Value)
            };

            return Ok(settings);
        }


        [Permission("System Settings", PermissionType.Modify)]
        [Route("[action]")]
        public async Task<IActionResult> SaveDetail(SystemSettingsDetail settings)
        {
            (await db.AppSettings.Where(x => x.Name == "SQLTimeOut").FirstAsync()).Value = settings.sqlTimeout.ToString();
            (await db.AppSettings.Where(x => x.Name == "DealModifyTimeLag").FirstAsync()).Value = settings.timeLag.ToString();
            (await db.AppSettings.Where(x => x.Name == "DealCount").FirstAsync()).Value = settings.dealsToLoad.ToString();
            (await db.AppSettings.Where(x => x.Name == "UseOriginalDateForSaveAsNewDeal").FirstAsync()).Value = settings.useOrigDate ? "1" : "0";
            (await db.AppSettings.Where(x => x.Name == "DefaultExecutionMargin").FirstAsync()).Value = settings.execMargin.ToString();
            (await db.AppSettings.Where(x => x.Name == "ExtraLogging").FirstAsync()).Value = settings.extraLog ? "1" : "0";
            (await db.AppSettings.Where(x => x.Name == "CmeFileCount").FirstAsync()).Value = settings.cmeFileCount.ToString();

            await db.SaveChangesAsync();

            return Ok();
        }
    }
}
