import { inject, Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { OdataGridHelper } from '../_shared/utils/odata-grid-helper';
import { Observable } from 'rxjs';

export interface Detail {
  sqlTimeout: number;
  timeLag: number;
  dealsToLoad: number;
  useOrigDate: boolean;
  execMargin: number;
  extraLog: boolean;
  cmeFileCount: number;
}

export interface RequiredData {
  hasModifyPermission: boolean;
}

@Injectable({
  providedIn: 'root'
})
export class SystemSettingsService extends OdataGridHelper {
  private baseUrl = `${window.location.origin}/api/SystemSettings`;
  http = inject(HttpClient);

  requiredData$ = this.http.get<RequiredData>(`${this.baseUrl}/getRequiredData`)

  getDetail(): Observable<Detail> {
    const url = `${this.baseUrl}/GetDetail?`;
    return this.http.get<Detail>(url);
  }

  saveDetail(detail: Detail): Observable<number> {
    const url = `${this.baseUrl}/SaveDetail?`;
    return this.http.put<number>(url, detail);
  }

}
