import { inject, Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { OdataGridHelper } from '../_shared/utils/odata-grid-helper';
import { Observable } from 'rxjs';

export interface Detail {
  showPasswords: boolean;
  dealAlter: string;
  arapAlter: string;
  overdueAlter: string;
  pdfEdit: string;
  accountingExport: string;
}

export interface RequiredData {
  hasModifyPermission: boolean;
}

@Injectable({
  providedIn: 'root'
})
export class SystemPasswordsService extends OdataGridHelper {
  private baseUrl = `${window.location.origin}/api/SystemPasswords`;
  http = inject(HttpClient);

  requiredData$ = this.http.get<RequiredData>(`${this.baseUrl}/getRequiredData`)

  getDetail(id: number): Observable<Detail> {
    const url = `${this.baseUrl}/GetDetail?id=${id}`;
    return this.http.get<Detail>(url);
  }

  saveDetail(detail: Detail): Observable<number> {
    const url = `${this.baseUrl}/SaveDetail?`;
    return this.http.put<number>(url, detail);
  }

}
