import { inject, Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { OdataGridHelper } from '../_shared/utils/odata-grid-helper';
import { Observable } from 'rxjs';
import { State } from '@progress/kendo-data-query';
import { GridDataResult } from '@progress/kendo-angular-grid';

export interface Item {
  MeterTypeId: number;
  MeterType: string;
}

export interface Detail {
  meterTypeName: string;
  meterTypeId: number;
}

export enum SaveType {
  New = 1,
  Normal = 2
}

export interface RequiredData {
  hasModifyPermission: boolean;
}

@Injectable({
  providedIn: 'root'
})
export class MeterTypeService extends OdataGridHelper {
  private baseUrl = `${window.location.origin}/api/MeterType`;
  http = inject(HttpClient);

  requireData$ = this.http.get<RequiredData>(`${this.baseUrl}/getRequiredData`)

  getItems(state: State): Observable<GridDataResult> {
    return this.fetch(`GetMeterTypeItems`, state, null, false)
  }

  getDetail(MeterTypeName: string): Observable<Detail> {
    const url = `${this.baseUrl}/GetDetail?MeterTypeName=${MeterTypeName}`;
    return this.http.get<Detail>(url);
  }

  saveDetail(detail: Detail, saveType: SaveType): Observable<number> {
    const url = `${this.baseUrl}/SaveDetail?saveType=${saveType}`;
    return this.http.put<number>(url, detail);
  }

  deleteDetail(Name: string) {
    const url = `${this.baseUrl}/DeleteMeterType/${Name}`;
    return this.http.delete(url);
  }

  exportItems(state: State, fileNameOriginal: string) {
    return this.fetchExport(`GetMeterTypeItems`, state, null, fileNameOriginal);
  }
}
