import { inject, Injectable } from '@angular/core';
import { OdataGridHelper } from '../_shared/utils/odata-grid-helper';
import { HttpClient } from '@angular/common/http';
import { Observable } from 'rxjs';
import { IdName } from '../_shared/utils/util';

export interface CommonDetail {
  meterId: number;
  name: string;
  inactiveDate: Date;
  stateId: number;
  countyId: number;
  locationId: number;
  leaseId: number;
  latitude: number;
  longitude: number;
  producerIds: number[];
}

export interface RequiredData {
  hasModifyPermission: boolean;
  stateNames: IdName[];
  counties: countyItem[];
  producers: IdName[];
  blocks: IdName[];
  locations: IdName[];
}

export interface countyItem {
  countyId: number;
  countyName: string;
  stateId: number;
  stateName: string;
}

export enum SaveType {
  New = 1,
  Normal = 2
}

@Injectable({
  providedIn: 'root'
})
export class MeterCommonService extends OdataGridHelper {
  private baseUrl = `${window.location.origin}/api/MeterCommon`;
  http = inject(HttpClient);

  requiredData$ = this.http.get<RequiredData>(`${this.baseUrl}/getRequiredData`)

  getDetail(id: number): Observable<CommonDetail> {
    const url = `${this.baseUrl}/GetDetail?MeterId=${id}`;
    return this.http.get<CommonDetail>(url);
  }

}
