import { inject, Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { OdataGridHelper } from '../_shared/utils/odata-grid-helper';
import { Observable } from 'rxjs';
import { State } from '@progress/kendo-data-query';
import { GridDataResult } from '@progress/kendo-angular-grid';
import * as util from '../_shared/utils/util';

export interface Item {
  LocationId: number;
  LocationName: string;
}

export interface Detail {
  locationName: string;
  locationId: number;
}

export interface RequiredData {
  hasModifyPermission: boolean;
  stateNames: util.IdName[];
}

export enum SaveType {
  New = 1,
  Normal = 2
}

@Injectable({
  providedIn: 'root'
})
export class LocationService extends OdataGridHelper {
  private baseUrl = `${window.location.origin}/api/location`;
  http = inject(HttpClient);

  requiredData$ = this.http.get<RequiredData>(`${this.baseUrl}/GetRequiredData`)

  getLocation(state: State): Observable<GridDataResult> {
    return this.fetch(`GetLocation`, state, null, false)
  }

  getDetail(LocationName: string): Observable<Detail> {
    const url = `${this.baseUrl}/GetDetail?LocationName=${LocationName}`;
    return this.http.get<Detail>(url);
  }

  saveLocation(detail: Detail, saveType: SaveType): Observable<number> {
    const url = `${this.baseUrl}/Savelocation?saveType=${saveType}`;
    return this.http.put<number>(url, detail);
  }

  deleteLocation(Name: string) {
    const url = `${this.baseUrl}/Deletelocation/${Name}`;
    return this.http.delete(url);
  }

  exportLocation(state: State, fileNameOriginal: string) {
    return this.fetchExport(`GetLocation`, state, null, fileNameOriginal);
  }
}
