import { inject, Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { OdataGridHelper } from '../_shared/utils/odata-grid-helper';
import { Observable } from 'rxjs';
import * as util from '../_shared/utils/util';

export interface Detail {
  emailSettingsId: number;
  smtpServer: string;
  port: number;
  userName: string;
  password: string;
  connectionType: number;
}

export interface RequiredData {
  hasModifyPermission: boolean;
  connectionTypes: util.IdName;
}

@Injectable({
  providedIn: 'root'
})
export class EmailSettingsService extends OdataGridHelper {
  private baseUrl = `${window.location.origin}/api/EmailSettings`;
  http = inject(HttpClient);

  requiredData$ = this.http.get<RequiredData>(`${this.baseUrl}/getRequiredData`)

  getDetail(id: number): Observable<Detail> {
    const url = `${this.baseUrl}/GetDetail?id=${id}`;
    return this.http.get<Detail>(url);
  }

  saveDetail(detail: Detail): Observable<number> {
    const url = `${this.baseUrl}/SaveDetail?`;
    return this.http.put<number>(url, detail);
  }

  sendNewTestEmail(detail: Detail, Address: string) {
    const url = `${this.baseUrl}/SendTestEmail/${Address}`;
    return this.http.post(url, detail);
  };

}
