import { inject, Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { OdataGridHelper } from '../_shared/utils/odata-grid-helper';
import { Observable } from 'rxjs';
import { State } from '@progress/kendo-data-query';
import { GridDataResult } from '@progress/kendo-angular-grid';
import { IdName } from '../_shared/utils/util';

export interface Item {
  Id: number;
  CountyId: number;
  CountyName: string;
  StateId: number;
  StateName: string;
}

export interface Detail {
  id: number;
  countyName: string;
  stateId: number;
}

export interface CountyItem {
  id: number;
  countyName: string;
  stateId: number;
}

export enum SaveType {
  New = 1,
  Normal = 2
}

export interface RequiredData {
  hasModifyPermission: boolean;
  states: IdName[];
  counties: CountyItem[];
}

@Injectable({
  providedIn: 'root'
})
export class CountyService extends OdataGridHelper {
  private baseUrl = `${window.location.origin}/api/County`;
  http = inject(HttpClient);

  requiredData$ = this.http.get<RequiredData>(`${this.baseUrl}/getRequiredData`)

  getItems(state: State): Observable<GridDataResult> {
    return this.fetch(`GetCountyItems`, state, null, false)
  }

  getDetail(id: number): Observable<Detail> {
    const url = `${this.baseUrl}/GetDetail?id=${id}`;
    return this.http.get<Detail>(url);
  }

  saveDetail(detail: Detail, saveType: SaveType): Observable<number> {
    const url = `${this.baseUrl}/SaveDetail?saveType=${saveType}`;
    return this.http.put<number>(url, detail);
  }

  deleteDetail(id: number) {
    const url = `${this.baseUrl}/DeleteDetail/${id}`;
    return this.http.delete(url);
  }

  exportItems(state: State, fileNameOriginal: string) {
    return this.fetchExport(`GetCountyItems`, state, null, fileNameOriginal);
  }

}
