import { Routes } from '@angular/router';
import { NotFoundComponent } from './_shared/not-found.component';
import { RedirectGuard } from './_shared/redirect.guard';
import { RedirectComponent } from './_shared/redirect.component';
import { DefaultRouteRedirectComponent } from './_shared/default-route-redirect.component';
import { InfoComponent } from './_shared/info.component';
import { TestComponent } from './_test/test.component';
import { inject } from '@angular/core';
import { AuthService } from './_shared/services/auth.service';
import { filter, map, take } from 'rxjs/operators';
// import app-specific components here:
import { BookComponent } from './book/book.component';
import { EmailSettingsComponent } from './email-settings/email-settings.component';
import { SystemPasswordsComponent } from './system-passwords/system-passwords.component';
import { SystemSettingsComponent } from './system-settings/system-settings.component';
import { BrokerComponent } from './broker/broker.component';
import { StrategyComponent } from './strategy/strategy.component';
import { StorageFacilityComponent } from './storage-facility/storage-facility.component';
import { NotificationComponent } from './notification/notification.component';
import { PortfolioComponent } from './portfolio/portfolio.component';
import { TransferMeterComponent } from './transfer-meter/transfer-meter.component';
import { PointComponent } from './point/point.component';
import { ZoneComponent } from './zone/zone.component';
import { ForceMajeureComponent } from './force-majeure/force-majeure.component';
import { PipelineComponent } from './pipeline/pipeline.component';
import { CountyComponent } from './county/county.component';
import { HolidayComponent } from './holiday/holiday.component';
import { LeaseComponent } from './lease/lease.component';
import { LocationComponent } from './location/location.component';
import { MeterComponent } from './meter/meter.component';
import { MeterTypeComponent } from './metertype/metertype.component';
import { TemplateComponent } from './template/template.component';

export const defaultRoute = 'Book';

// Angular Functional Route Guard for authentication
export const oauthAuthGuard = () => {
  const authService = inject(AuthService);

  if (authService.authCheckComplete$.getValue() && authService.isLoggedIn())
    return true;

  if (authService.authCheckComplete$.getValue() && !authService.isLoggedIn()) {
    authService.login();
    return false;
  }

  return authService.authCheckComplete$.pipe(
    filter(complete => complete), // Wait until auth check is complete
    take(1), // Only take the first emission after completion
    map(() => {
      if (authService.isLoggedIn())
        return true;
      else {
        authService.login();
        return false; // Prevent Angular routing while redirecting
      }
    })
  );
};

/*
  do not add a path directly to AppComponent
  main.ts bootstraps to AppComponent which has a router-outlet that may then load a duplicate AppComponent
*/
export const routes: Routes = [
  { path: 'externalRedirect', canActivate: [RedirectGuard], component: RedirectComponent, data: { externalUrl: '' } },
  // add app-specific routes here:
  // { path: 'ExamplePath', component: ExampleComponent, canActivate: [oauthAuthGuard] },
  { path: 'Book', component: BookComponent, canActivate: [oauthAuthGuard] },
  { path: 'Broker', component: BrokerComponent, canActivate: [oauthAuthGuard] },
  { path: 'County', component: CountyComponent, canActivate: [oauthAuthGuard] },
  { path: 'EmailSettings', component: EmailSettingsComponent, canActivate: [oauthAuthGuard] },
  { path: 'ForceMajeure', component: ForceMajeureComponent, canActivate: [oauthAuthGuard] },
  { path: 'Holiday', component: HolidayComponent, canActivate: [oauthAuthGuard] },
  { path: 'Lease', component: LeaseComponent, canActivate: [oauthAuthGuard] },
  { path: 'Location', component: LocationComponent, canActivate: [oauthAuthGuard] },
  { path: 'Meter', component: MeterComponent, canActivate: [oauthAuthGuard] },
  { path: 'MeterType', component: MeterTypeComponent, canActivate: [oauthAuthGuard] },
  { path: 'Notification', component: NotificationComponent, canActivate: [oauthAuthGuard] },
  { path: 'Pipeline', component: PipelineComponent, canActivate: [oauthAuthGuard] },
  { path: 'Point', component: PointComponent, canActivate: [oauthAuthGuard] },
  { path: 'Portfolio', component: PortfolioComponent, canActivate: [oauthAuthGuard] },
  { path: 'StorageFacility', component: StorageFacilityComponent, canActivate: [oauthAuthGuard] },
  { path: 'Strategy', component: StrategyComponent, canActivate: [oauthAuthGuard] },
  { path: 'SystemPasswords', component: SystemPasswordsComponent, canActivate: [oauthAuthGuard] },
  { path: 'SystemSettings', component: SystemSettingsComponent, canActivate: [oauthAuthGuard] },
  { path: 'Template', component: TemplateComponent, canActivate: [oauthAuthGuard] },
  { path: 'TransferMeter', component: TransferMeterComponent, canActivate: [oauthAuthGuard] },
  { path: 'Zone', component: ZoneComponent, canActivate: [oauthAuthGuard] },
  // end app-specific routes
  { path: 'Info', component: InfoComponent, canActivate: [oauthAuthGuard] },
  { path: '', component: DefaultRouteRedirectComponent, pathMatch: 'full' },
  { path: 'Test/:tag', component: TestComponent }, //view Test page to display a component based on the tag
  { path: 'Test', component: TestComponent }, //view blank Test page
  { path: '**', component: NotFoundComponent, data: { title: 'Not Found' } }
];
