import { Pipe, PipeTransform } from '@angular/core';

@Pipe({
  name: 'winWidth'
})
export class WinWidthPipe implements PipeTransform {
  transform(maxWidth: number = 1800): number {
    if (!maxWidth || maxWidth === 0)
      maxWidth = 1800;

    if (window.innerWidth > maxWidth)
      return maxWidth;

    return window.innerWidth - 50;
  }
}
