
import { CommonModule } from "@angular/common";
import { Component, input } from "@angular/core";


@Component({
  selector: 'fast-svg',
  standalone: true,
  imports: [CommonModule],
  template: `
    <svg
      [attr.width]="size()"
      [attr.height]="size()"
      [attr.viewBox]="'0 0 ' + size() + ' ' + size()"
      [style.color]="color()"
      [style.fill]="fillColor()"
      [style.stroke]="strokeColor()"
      [attr.stroke-width]="strokeWidth()"
    >
      <use [attr.href]="'#' + icon()"></use>
    </svg>
  `,
  styles: `
      :host {
        display: inline-flex;
        align-items: center;
        justify-content: center;
      }
      svg {
        display: block;
      }
    `,
  host: {
    '[class]': 'class()',
  },
})
export class FastSVGComponent {
  icon = input<string>();
  size = input<string | number>(18);
  color = input<string>('currentColor');
  strokeColor = input<string>('currentColor');
  fillColor = input<string>('currentColor');
  strokeWidth = input<number>(2);
  class = input<string>('');
}
