using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("quality_bank_adjustment_detail")]
[Index("MeterId", "TitleMeterId", "QualityBankAdjustmentId", Name = "uk_quality_bank_adjustment", IsUnique = true)]
public partial class QualityBankAdjustmentDetail
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("meter_id")]
    public int MeterId { get; set; }

    [Column("title_meter_id")]
    public int TitleMeterId { get; set; }

    [Column("qb_1")]
    public decimal? Qb1 { get; set; }

    [Column("qb_2")]
    public decimal? Qb2 { get; set; }

    [Column("qb_3")]
    public decimal? Qb3 { get; set; }

    [Column("qb_4")]
    public decimal? Qb4 { get; set; }

    [Column("quality_bank_adjustment_id")]
    public int QualityBankAdjustmentId { get; set; }

    [ForeignKey("QualityBankAdjustmentId")]
    [InverseProperty("QualityBankAdjustmentDetails")]
    public virtual QualityBankAdjustment QualityBankAdjustment { get; set; } = null!;
}
