using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("plant")]
[Index("IsActive", Name = "ix_plant_2")]
[Index("IsActive", "Id", Name = "ix_plant_3")]
[Index("Name", Name = "uk_plant", IsUnique = true)]
public partial class Plant
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [Column("is_active")]
    public bool IsActive { get; set; }

    [Column("number", TypeName = "citext")]
    public string? Number { get; set; }

    [Column("type")]
    public int? Type { get; set; }

    [InverseProperty("Plant")]
    public virtual ICollection<PlantNote> PlantNotes { get; set; } = new List<PlantNote>();

    [InverseProperty("Plant")]
    public virtual ICollection<PlantStatementOption> PlantStatementOptions { get; set; } = new List<PlantStatementOption>();

    [InverseProperty("Plant")]
    public virtual ICollection<PlantStatementPrice> PlantStatementPrices { get; set; } = new List<PlantStatementPrice>();

    [InverseProperty("Plant")]
    public virtual ICollection<PlantStatement> PlantStatements { get; set; } = new List<PlantStatement>();
}
