using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("pipeline_rate_schedule")]
[Index("PipelineId", "ContractType", "Name", Name = "uk_pipeline_rate_schedule", IsUnique = true)]
public partial class PipelineRateSchedule
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [Column("pipeline_id")]
    public int PipelineId { get; set; }

    [Column("contract_type")]
    public int ContractType { get; set; }

    [Column("product_id")]
    public int ProductId { get; set; }

    [ForeignKey("ContractType")]
    [InverseProperty("PipelineRateSchedules")]
    public virtual PipelineContractType ContractTypeNavigation { get; set; } = null!;

    [ForeignKey("PipelineId")]
    [InverseProperty("PipelineRateSchedules")]
    public virtual Pipeline Pipeline { get; set; } = null!;

    [InverseProperty("RateSchedule")]
    public virtual ICollection<PipelineContract> PipelineContracts { get; set; } = new List<PipelineContract>();

    [InverseProperty("RateSchedule")]
    public virtual ICollection<PipelineRateDiscounted> PipelineRateDiscounteds { get; set; } = new List<PipelineRateDiscounted>();

    [InverseProperty("RateSchedule")]
    public virtual ICollection<PipelineTariff> PipelineTariffs { get; set; } = new List<PipelineTariff>();

    [ForeignKey("ProductId")]
    [InverseProperty("PipelineRateSchedules")]
    public virtual Product Product { get; set; } = null!;
}
