using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("payment_instruction")]
[Index("CounterpartyId", "EffectiveDate", Name = "uk_payment_instruction", IsUnique = true)]
public partial class PaymentInstruction
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("counterparty_id")]
    public int CounterpartyId { get; set; }

    [Column("effective_date")]
    public DateOnly EffectiveDate { get; set; }

    [Column("bank_name", TypeName = "citext")]
    public string? BankName { get; set; }

    [Column("bank_city", TypeName = "citext")]
    public string? BankCity { get; set; }

    [Column("bank_state_id")]
    public int? BankStateId { get; set; }

    [Column("bank_wire_num", TypeName = "citext")]
    public string? BankWireNum { get; set; }

    [Column("bank_wire_city", TypeName = "citext")]
    public string? BankWireCity { get; set; }

    [Column("bank_wire_state_id")]
    public int? BankWireStateId { get; set; }

    [Column("bank_ach_num", TypeName = "citext")]
    public string? BankAchNum { get; set; }

    [Column("bank_ach_city", TypeName = "citext")]
    public string? BankAchCity { get; set; }

    [Column("bank_ach_state_id")]
    public int? BankAchStateId { get; set; }

    [Column("account_holder", TypeName = "citext")]
    public string? AccountHolder { get; set; }

    [Column("account_num", TypeName = "citext")]
    public string? AccountNum { get; set; }

    [Column("swift_code", TypeName = "citext")]
    public string? SwiftCode { get; set; }

    [Column("further_credit_to", TypeName = "citext")]
    public string? FurtherCreditTo { get; set; }

    [Column("further_credit_account_num", TypeName = "citext")]
    public string? FurtherCreditAccountNum { get; set; }

    [Column("notes", TypeName = "citext")]
    public string? Notes { get; set; }

    [Column("has_payment_type_ccd")]
    public bool HasPaymentTypeCcd { get; set; }

    [Column("has_payment_type_ctx")]
    public bool HasPaymentTypeCtx { get; set; }

    [Column("has_payment_type_ppd")]
    public bool HasPaymentTypePpd { get; set; }

    [Column("has_payment_type_tax")]
    public bool HasPaymentTypeTax { get; set; }

    [Column("has_payment_type_wire")]
    public bool HasPaymentTypeWire { get; set; }

    [ForeignKey("BankAchStateId")]
    [InverseProperty("PaymentInstructionBankAchStates")]
    public virtual Territory? BankAchState { get; set; }

    [ForeignKey("BankStateId")]
    [InverseProperty("PaymentInstructionBankStates")]
    public virtual Territory? BankState { get; set; }

    [ForeignKey("BankWireStateId")]
    [InverseProperty("PaymentInstructionBankWireStates")]
    public virtual Territory? BankWireState { get; set; }

    [ForeignKey("CounterpartyId")]
    [InverseProperty("PaymentInstructions")]
    public virtual Counterparty Counterparty { get; set; } = null!;

    [InverseProperty("PaymentInstruction")]
    public virtual ICollection<PaymentInstructionDoc> PaymentInstructionDocs { get; set; } = new List<PaymentInstructionDoc>();
}
