using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("credit_limit")]
[Index("ParentCounterpartyId", "ApprovedDate", "ExpirationDate", Name = "uk_credit_limit_parent_counterparty", IsUnique = true)]
public partial class CreditLimit
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("parent_counterparty_id")]
    public int ParentCounterpartyId { get; set; }

    [Column("approved_credit_limit")]
    public decimal ApprovedCreditLimit { get; set; }

    [Column("approved_date")]
    public DateOnly ApprovedDate { get; set; }

    [Column("reviewed_date")]
    public DateOnly? ReviewedDate { get; set; }

    [Column("expiration_date")]
    public DateOnly? ExpirationDate { get; set; }

    [Column("is_over_limit_exception")]
    public bool IsOverLimitException { get; set; }

    [Column("exception_credit_limit")]
    public decimal? ExceptionCreditLimit { get; set; }

    [Column("exception_expiration_date")]
    public DateOnly? ExceptionExpirationDate { get; set; }

    [Column("total_credit_limit")]
    public decimal TotalCreditLimit { get; set; }

    [Column("notes", TypeName = "citext")]
    public string? Notes { get; set; }

    [InverseProperty("CreditLimit")]
    public virtual ICollection<CreditLimitApproval> CreditLimitApprovals { get; set; } = new List<CreditLimitApproval>();

    [InverseProperty("CreditLimit")]
    public virtual ICollection<CreditLimitCounterparty> CreditLimitCounterparties { get; set; } = new List<CreditLimitCounterparty>();

    [ForeignKey("ParentCounterpartyId")]
    [InverseProperty("CreditLimits")]
    public virtual Counterparty ParentCounterparty { get; set; } = null!;
}
