using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("country")]
[Index("Name", Name = "uk_country", IsUnique = true)]
public partial class Country
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [Column("code", TypeName = "citext")]
    public string Code { get; set; } = null!;

    [InverseProperty("Country")]
    public virtual ICollection<Contact> Contacts { get; set; } = new List<Contact>();

    [InverseProperty("ChecksCountry")]
    public virtual ICollection<ContractAccounting> ContractAccountingChecksCountries { get; set; } = new List<ContractAccounting>();

    [InverseProperty("InvoiceCountry")]
    public virtual ICollection<ContractAccounting> ContractAccountingInvoiceCountries { get; set; } = new List<ContractAccounting>();

    [InverseProperty("CommercialCountry")]
    public virtual ICollection<ContractContact> ContractContactCommercialCountries { get; set; } = new List<ContractContact>();

    [InverseProperty("ConfirmationsCountry")]
    public virtual ICollection<ContractContact> ContractContactConfirmationsCountries { get; set; } = new List<ContractContact>();

    [InverseProperty("CreditCountry")]
    public virtual ICollection<ContractContact> ContractContactCreditCountries { get; set; } = new List<ContractContact>();

    [InverseProperty("NoticesCountry")]
    public virtual ICollection<ContractContact> ContractContactNoticesCountries { get; set; } = new List<ContractContact>();

    [InverseProperty("SchedulingCountry")]
    public virtual ICollection<ContractContact> ContractContactSchedulingCountries { get; set; } = new List<ContractContact>();

    [InverseProperty("CheckPaymentCountry")]
    public virtual ICollection<ContractExhibitC> ContractExhibitCs { get; set; } = new List<ContractExhibitC>();

    [InverseProperty("Country")]
    public virtual ICollection<Counterparty> Counterparties { get; set; } = new List<Counterparty>();

    [InverseProperty("CounterpartyCountry")]
    public virtual ICollection<InvoiceCrude> InvoiceCrudeCounterpartyCountries { get; set; } = new List<InvoiceCrude>();

    [InverseProperty("InternalEntityCountry")]
    public virtual ICollection<InvoiceCrude> InvoiceCrudeInternalEntityCountries { get; set; } = new List<InvoiceCrude>();

    [InverseProperty("CounterpartyCountry")]
    public virtual ICollection<InvoiceGa> InvoiceGaCounterpartyCountries { get; set; } = new List<InvoiceGa>();

    [InverseProperty("InternalEntityCountry")]
    public virtual ICollection<InvoiceGa> InvoiceGaInternalEntityCountries { get; set; } = new List<InvoiceGa>();
}
