using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("contract_exhibit_b_selection")]
public partial class ContractExhibitBSelection
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("contract_id")]
    public int ContractId { get; set; }

    [Column("contract_exhibit_b_id")]
    public int ContractExhibitBId { get; set; }

    [ForeignKey("ContractId")]
    [InverseProperty("ContractExhibitBSelections")]
    public virtual Contract Contract { get; set; } = null!;

    [ForeignKey("ContractExhibitBId")]
    [InverseProperty("ContractExhibitBSelections")]
    public virtual ContractExhibitB ContractExhibitB { get; set; } = null!;
}
