using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("contact_to_contact_type")]
[Index("ContactId", "ContactTypeId", Name = "uk_contact_types_map", IsUnique = true)]
public partial class ContactToContactType
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("contact_id")]
    public int ContactId { get; set; }

    [Column("contact_type_id")]
    public int ContactTypeId { get; set; }

    [ForeignKey("ContactId")]
    [InverseProperty("ContactToContactTypes")]
    public virtual Contact Contact { get; set; } = null!;

    [ForeignKey("ContactTypeId")]
    [InverseProperty("ContactToContactTypes")]
    public virtual ContactType ContactType { get; set; } = null!;
}
