using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("buy_sell_type")]
public partial class BuySellType
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string? Name { get; set; }

    [Column("reserved_field", TypeName = "citext")]
    public string? ReservedField { get; set; }

    [InverseProperty("BuyButtonNavigation")]
    public virtual ICollection<Deal> Deals { get; set; } = new List<Deal>();
}
