using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("benchmark")]
[Index("Name", Name = "uk_benchmark_index", IsUnique = true)]
[Index("Name", Name = "uk_benchmark_index2", IsUnique = true)]
public partial class Benchmark
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [Column("description", TypeName = "citext")]
    public string Description { get; set; } = null!;

    [InverseProperty("Benchmark")]
    public virtual ICollection<ProductExpiration> ProductExpirations { get; set; } = new List<ProductExpiration>();
}
