namespace Fast.Database.Models;

public class ValItem
{
    //here we list all the shared properties between ValDeal and ValDealVolume
    //this is so that we can use the same filter logic for both in Valuation.cs
    public string TicketNum { get; set; } = "";
    public DateOnly StartDate { get; set; }
    public DateOnly EndDate { get; set; }
    public DateOnly? TradingDate { get; set; }
    public DateOnly? AccountingMonth { get; set; }
    public int? BuyButton { get; set; }
    public int? HypotheticalId { get; set; }
    public int? TransactionTypeId { get; set; }
    public int? IsPooledFutureDeal { get; set; }
    public int? PriceIndexId { get; set; }
    public int? PriceIndexId2 { get; set; }
    public int? BookId { get; set; }
    public int? BrokerId { get; set; }
    public int? BrokerAccountId { get; set; }
    public int ProductId { get; set; }
    public int ProductCategoryId { get; set; }
    public int? CounterpartyId { get; set; }
    public int? DealPurposeId { get; set; }
    public int? DealStatusId { get; set; }
    public int? InternalEntityId { get; set; }
    public int? PhysicalDealTypeId { get; set; }
    public int? PipelineId { get; set; }
    public int? PipelineSourceDeliveryId { get; set; }
    public int? PointId { get; set; }
    public int? PortfolioId { get; set; }
    public int? RegionId { get; set; }
    public int? StrategyId { get; set; }
    public int? TraderId { get; set; }
    public string WaspNum { get; set; } = "";
}

public partial class VwValDeal : ValItem
{
    //empty but still needed so that we can specify inheritance
}

public partial class VwValDealVolume : ValItem
{
    //empty but still needed so that we can specify inheritance
}
