using System;
using System.Collections.Generic;
using Microsoft.AspNetCore.DataProtection.EntityFrameworkCore;
using Microsoft.AspNetCore.Identity;
using Microsoft.AspNetCore.Identity.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

// Implefast modified by t4: class inheritance begin
public partial class MyDbContext : IdentityDbContext<AppUser, IdentityRole<int>, int>, IDataProtectionKeyContext
// Implefast modified by t4: class inherticance end
{
    public MyDbContext(DbContextOptions<MyDbContext> options)
        : base(options)
    {
    }

    //Implefast modified by t4: add custom DataProtectionKeys DbSet begin
    public DbSet<DataProtectionKey> DataProtectionKeys { get; set; } = null!;
    //Implefast modified by t4: add custom DataProtectionKeys DbSet end
    public virtual DbSet<ActualType> ActualTypes { get; set; }

    public virtual DbSet<ActualizationFilter> ActualizationFilters { get; set; }

    public virtual DbSet<AppLog> AppLogs { get; set; }

    public virtual DbSet<AppSetting> AppSettings { get; set; }

    public virtual DbSet<AppUser> AppUsers { get; set; }

    public virtual DbSet<AspRole> AspRoles { get; set; }

    public virtual DbSet<AspRoleClaim> AspRoleClaims { get; set; }

    public virtual DbSet<AspUserClaim> AspUserClaims { get; set; }

    public virtual DbSet<AspUserLogin> AspUserLogins { get; set; }

    public virtual DbSet<AspUserToken> AspUserTokens { get; set; }

    public virtual DbSet<BankRouting> BankRoutings { get; set; }

    public virtual DbSet<Benchmark> Benchmarks { get; set; }

    public virtual DbSet<Book> Books { get; set; }

    public virtual DbSet<BookToTrader> BookToTraders { get; set; }

    public virtual DbSet<Broker> Brokers { get; set; }

    public virtual DbSet<BrokerAccount> BrokerAccounts { get; set; }

    public virtual DbSet<BrokerMemo> BrokerMemos { get; set; }

    public virtual DbSet<BusinessRelationship> BusinessRelationships { get; set; }

    public virtual DbSet<BusinessSubType> BusinessSubTypes { get; set; }

    public virtual DbSet<BusinessType> BusinessTypes { get; set; }

    public virtual DbSet<BuySellType> BuySellTypes { get; set; }

    public virtual DbSet<Calendar> Calendars { get; set; }

    public virtual DbSet<CallPutType> CallPutTypes { get; set; }

    public virtual DbSet<CollateralType> CollateralTypes { get; set; }

    public virtual DbSet<Contact> Contacts { get; set; }

    public virtual DbSet<ContactCounterparty> ContactCounterparties { get; set; }

    public virtual DbSet<ContactToContactType> ContactToContactTypes { get; set; }

    public virtual DbSet<ContactType> ContactTypes { get; set; }

    public virtual DbSet<Contract> Contracts { get; set; }

    public virtual DbSet<ContractAccounting> ContractAccountings { get; set; }

    public virtual DbSet<ContractContact> ContractContacts { get; set; }

    public virtual DbSet<ContractCrude> ContractCrudes { get; set; }

    public virtual DbSet<ContractCrudePoint> ContractCrudePoints { get; set; }

    public virtual DbSet<ContractDoc> ContractDocs { get; set; }

    public virtual DbSet<ContractExhibitB> ContractExhibitBs { get; set; }

    public virtual DbSet<ContractExhibitBSelection> ContractExhibitBSelections { get; set; }

    public virtual DbSet<ContractExhibitC> ContractExhibitCs { get; set; }

    public virtual DbSet<ContractNaesb> ContractNaesbs { get; set; }

    public virtual DbSet<ContractOther> ContractOthers { get; set; }

    public virtual DbSet<ContractPaymentType> ContractPaymentTypes { get; set; }

    public virtual DbSet<ContractStatus> ContractStatuses { get; set; }

    public virtual DbSet<Counterparty> Counterparties { get; set; }

    public virtual DbSet<CounterpartyDun> CounterpartyDuns { get; set; }

    public virtual DbSet<CounterpartyParent> CounterpartyParents { get; set; }

    public virtual DbSet<CounterpartyProduct> CounterpartyProducts { get; set; }

    public virtual DbSet<CounterpartyRelationship> CounterpartyRelationships { get; set; }

    public virtual DbSet<Country> Countries { get; set; }

    public virtual DbSet<County> Counties { get; set; }

    public virtual DbSet<CreditLimit> CreditLimits { get; set; }

    public virtual DbSet<CreditLimitApproval> CreditLimitApprovals { get; set; }

    public virtual DbSet<CreditLimitCollateral> CreditLimitCollaterals { get; set; }

    public virtual DbSet<CreditLimitCollateralBeneficiary> CreditLimitCollateralBeneficiaries { get; set; }

    public virtual DbSet<CreditLimitCollateralDoc> CreditLimitCollateralDocs { get; set; }

    public virtual DbSet<CreditLimitCollateralProvider> CreditLimitCollateralProviders { get; set; }

    public virtual DbSet<CreditLimitCounterparty> CreditLimitCounterparties { get; set; }

    public virtual DbSet<CrudeActual> CrudeActuals { get; set; }

    public virtual DbSet<CrudeMarket> CrudeMarkets { get; set; }

    public virtual DbSet<CrudeMarketSupply> CrudeMarketSupplies { get; set; }

    public virtual DbSet<CrudePath> CrudePaths { get; set; }

    public virtual DbSet<CrudePathRoute> CrudePathRoutes { get; set; }

    public virtual DbSet<CrudeSupply> CrudeSupplies { get; set; }

    public virtual DbSet<CurrencyType> CurrencyTypes { get; set; }

    public virtual DbSet<Deal> Deals { get; set; }

    public virtual DbSet<DealConfirmation> DealConfirmations { get; set; }

    public virtual DbSet<DealFilter> DealFilters { get; set; }

    public virtual DbSet<DealFilterParameter> DealFilterParameters { get; set; }

    public virtual DbSet<DealPurposeType> DealPurposeTypes { get; set; }

    public virtual DbSet<DealStatus> DealStatuses { get; set; }

    public virtual DbSet<DealVolume> DealVolumes { get; set; }

    public virtual DbSet<DeliveryMode> DeliveryModes { get; set; }

    public virtual DbSet<DunsNumber> DunsNumbers { get; set; }

    public virtual DbSet<EmailSetting> EmailSettings { get; set; }

    public virtual DbSet<Exchange> Exchanges { get; set; }

    public virtual DbSet<Favorite> Favorites { get; set; }

    public virtual DbSet<ForceMajeure> ForceMajeures { get; set; }

    public virtual DbSet<FuelCalculationType> FuelCalculationTypes { get; set; }

    public virtual DbSet<GasActual> GasActuals { get; set; }

    public virtual DbSet<GasMarket> GasMarkets { get; set; }

    public virtual DbSet<GasMarketSupply> GasMarketSupplies { get; set; }

    public virtual DbSet<GasPath> GasPaths { get; set; }

    public virtual DbSet<GasPathRoute> GasPathRoutes { get; set; }

    public virtual DbSet<GasSupply> GasSupplies { get; set; }

    public virtual DbSet<Holiday> Holidays { get; set; }

    public virtual DbSet<HolidaySchedule> HolidaySchedules { get; set; }

    public virtual DbSet<HypotheticalType> HypotheticalTypes { get; set; }

    public virtual DbSet<ImbalanceNomType> ImbalanceNomTypes { get; set; }

    public virtual DbSet<Industry> Industries { get; set; }

    public virtual DbSet<InvoiceCrude> InvoiceCrudes { get; set; }

    public virtual DbSet<InvoiceCrudeLine> InvoiceCrudeLines { get; set; }

    public virtual DbSet<InvoiceGa> InvoiceGas { get; set; }

    public virtual DbSet<InvoiceGasLine> InvoiceGasLines { get; set; }

    public virtual DbSet<InvoiceType> InvoiceTypes { get; set; }

    public virtual DbSet<Lease> Leases { get; set; }

    public virtual DbSet<LeaseType> LeaseTypes { get; set; }

    public virtual DbSet<Location> Locations { get; set; }

    public virtual DbSet<MarketIndex> MarketIndices { get; set; }

    public virtual DbSet<MarketIndexAlias> MarketIndexAliases { get; set; }

    public virtual DbSet<MarketIndexAliasType> MarketIndexAliasTypes { get; set; }

    public virtual DbSet<MarketIndexClassificationType> MarketIndexClassificationTypes { get; set; }

    public virtual DbSet<MarketIndexPublication> MarketIndexPublications { get; set; }

    public virtual DbSet<MarketIndexType> MarketIndexTypes { get; set; }

    public virtual DbSet<MarketPrice> MarketPrices { get; set; }

    public virtual DbSet<MarketType> MarketTypes { get; set; }

    public virtual DbSet<Meter> Meters { get; set; }

    public virtual DbSet<MeterProduct> MeterProducts { get; set; }

    public virtual DbSet<MeterProductDeliveryPoint> MeterProductDeliveryPoints { get; set; }

    public virtual DbSet<MeterProductSourcePoint> MeterProductSourcePoints { get; set; }

    public virtual DbSet<MeterPtr> MeterPtrs { get; set; }

    public virtual DbSet<MeterPtrExcluded> MeterPtrExcludeds { get; set; }

    public virtual DbSet<MeterType> MeterTypes { get; set; }

    public virtual DbSet<Notification> Notifications { get; set; }

    public virtual DbSet<OpenIddictApplication> OpenIddictApplications { get; set; }

    public virtual DbSet<OpenIddictAuthorization> OpenIddictAuthorizations { get; set; }

    public virtual DbSet<OpenIddictScope> OpenIddictScopes { get; set; }

    public virtual DbSet<OpenIddictToken> OpenIddictTokens { get; set; }

    public virtual DbSet<Password> Passwords { get; set; }

    public virtual DbSet<PaymentDateOption> PaymentDateOptions { get; set; }

    public virtual DbSet<PaymentDateType> PaymentDateTypes { get; set; }

    public virtual DbSet<PaymentInstruction> PaymentInstructions { get; set; }

    public virtual DbSet<PaymentInstructionDoc> PaymentInstructionDocs { get; set; }

    public virtual DbSet<PayoutType> PayoutTypes { get; set; }

    public virtual DbSet<PhysicalDealType> PhysicalDealTypes { get; set; }

    public virtual DbSet<PipeContractDeliveryMeter> PipeContractDeliveryMeters { get; set; }

    public virtual DbSet<PipeContractDeliveryZone> PipeContractDeliveryZones { get; set; }

    public virtual DbSet<PipeContractDoc> PipeContractDocs { get; set; }

    public virtual DbSet<PipeContractReceiptMeter> PipeContractReceiptMeters { get; set; }

    public virtual DbSet<PipeContractReceiptZone> PipeContractReceiptZones { get; set; }

    public virtual DbSet<PipeDiscountDoc> PipeDiscountDocs { get; set; }

    public virtual DbSet<PipeRateApplicationRule> PipeRateApplicationRules { get; set; }

    public virtual DbSet<PipeRateDoc> PipeRateDocs { get; set; }

    public virtual DbSet<Pipeline> Pipelines { get; set; }

    public virtual DbSet<PipelineContract> PipelineContracts { get; set; }

    public virtual DbSet<PipelineContractDefault> PipelineContractDefaults { get; set; }

    public virtual DbSet<PipelineContractType> PipelineContractTypes { get; set; }

    public virtual DbSet<PipelineRateDiscounted> PipelineRateDiscounteds { get; set; }

    public virtual DbSet<PipelineRateDiscountedCounterparty> PipelineRateDiscountedCounterparties { get; set; }

    public virtual DbSet<PipelineRateDiscountedFromTo> PipelineRateDiscountedFromTos { get; set; }

    public virtual DbSet<PipelineRateSchedule> PipelineRateSchedules { get; set; }

    public virtual DbSet<PipelineTariff> PipelineTariffs { get; set; }

    public virtual DbSet<PipelineTariffDatum> PipelineTariffData { get; set; }

    public virtual DbSet<PipelineTariffType> PipelineTariffTypes { get; set; }

    public virtual DbSet<PipelineType> PipelineTypes { get; set; }

    public virtual DbSet<Plant> Plants { get; set; }

    public virtual DbSet<PlantNote> PlantNotes { get; set; }

    public virtual DbSet<PlantStatement> PlantStatements { get; set; }

    public virtual DbSet<PlantStatementCombinedMeter> PlantStatementCombinedMeters { get; set; }

    public virtual DbSet<PlantStatementDescriptor> PlantStatementDescriptors { get; set; }

    public virtual DbSet<PlantStatementOption> PlantStatementOptions { get; set; }

    public virtual DbSet<PlantStatementPrice> PlantStatementPrices { get; set; }

    public virtual DbSet<Point> Points { get; set; }

    public virtual DbSet<PointProductGradeToIndex> PointProductGradeToIndices { get; set; }

    public virtual DbSet<PointSourceDelivery> PointSourceDeliveries { get; set; }

    public virtual DbSet<Portfolio> Portfolios { get; set; }

    public virtual DbSet<ProducerFee> ProducerFees { get; set; }

    public virtual DbSet<ProducerFeeType> ProducerFeeTypes { get; set; }

    public virtual DbSet<Product> Products { get; set; }

    public virtual DbSet<ProductCategory> ProductCategories { get; set; }

    public virtual DbSet<ProductExpiration> ProductExpirations { get; set; }

    public virtual DbSet<PublishedToInternalIndex> PublishedToInternalIndices { get; set; }

    public virtual DbSet<QualityBankAdjustment> QualityBankAdjustments { get; set; }

    public virtual DbSet<QualityBankAdjustmentDetail> QualityBankAdjustmentDetails { get; set; }

    public virtual DbSet<Region> Regions { get; set; }

    public virtual DbSet<Report> Reports { get; set; }

    public virtual DbSet<ReportDataSource> ReportDataSources { get; set; }

    public virtual DbSet<ReportFilter> ReportFilters { get; set; }

    public virtual DbSet<ReportFilterParameter> ReportFilterParameters { get; set; }

    public virtual DbSet<SalesTax> SalesTaxes { get; set; }

    public virtual DbSet<SalesTaxDetail> SalesTaxDetails { get; set; }

    public virtual DbSet<SalesTaxDoc> SalesTaxDocs { get; set; }

    public virtual DbSet<SalesTaxExemption> SalesTaxExemptions { get; set; }

    public virtual DbSet<SalesTaxExemptionDoc> SalesTaxExemptionDocs { get; set; }

    public virtual DbSet<SalesTaxRate> SalesTaxRates { get; set; }

    public virtual DbSet<SalesTaxType> SalesTaxTypes { get; set; }

    public virtual DbSet<Screen> Screens { get; set; }

    public virtual DbSet<SecurityAction> SecurityActions { get; set; }

    public virtual DbSet<SecurityGroup> SecurityGroups { get; set; }

    public virtual DbSet<SecurityGroupPermission> SecurityGroupPermissions { get; set; }

    public virtual DbSet<SecurityUserGroup> SecurityUserGroups { get; set; }

    public virtual DbSet<SettleType> SettleTypes { get; set; }

    public virtual DbSet<SeveranceTax> SeveranceTaxes { get; set; }

    public virtual DbSet<SosCrudePipeSetting> SosCrudePipeSettings { get; set; }

    public virtual DbSet<SosCrudeSetting> SosCrudeSettings { get; set; }

    public virtual DbSet<SosGasPipeSetting> SosGasPipeSettings { get; set; }

    public virtual DbSet<SosGasSetting> SosGasSettings { get; set; }

    public virtual DbSet<SosHiddenDeal> SosHiddenDeals { get; set; }

    public virtual DbSet<SosSnapshot> SosSnapshots { get; set; }

    public virtual DbSet<StateIncomeExemption> StateIncomeExemptions { get; set; }

    public virtual DbSet<StateIncomeExemptionDoc> StateIncomeExemptionDocs { get; set; }

    public virtual DbSet<StorageFacility> StorageFacilities { get; set; }

    public virtual DbSet<Strategy> Strategies { get; set; }

    public virtual DbSet<Template> Templates { get; set; }

    public virtual DbSet<Territory> Territories { get; set; }

    public virtual DbSet<Ticket> Tickets { get; set; }

    public virtual DbSet<TransactionType> TransactionTypes { get; set; }

    public virtual DbSet<TransferDeal> TransferDeals { get; set; }

    public virtual DbSet<TransferMeter> TransferMeters { get; set; }

    public virtual DbSet<UnitOfMeasure> UnitOfMeasures { get; set; }

    public virtual DbSet<UnitOfMeasureConversion> UnitOfMeasureConversions { get; set; }

    public virtual DbSet<UnitPriceCombination> UnitPriceCombinations { get; set; }

    public virtual DbSet<UserScreenSort> UserScreenSorts { get; set; }

    public virtual DbSet<VolumeType> VolumeTypes { get; set; }

    public virtual DbSet<VwBrokerOverviewInfo> VwBrokerOverviewInfos { get; set; }

    public virtual DbSet<VwBusinessCalendar> VwBusinessCalendars { get; set; }

    public virtual DbSet<VwBusinessTypeOverviewInfo> VwBusinessTypeOverviewInfos { get; set; }

    public virtual DbSet<VwContactOverviewInfo> VwContactOverviewInfos { get; set; }

    public virtual DbSet<VwCounterpartyOverviewInfo> VwCounterpartyOverviewInfos { get; set; }

    public virtual DbSet<VwCreditLimitCollateralOverview> VwCreditLimitCollateralOverviews { get; set; }

    public virtual DbSet<VwCrudePathFinalMeter> VwCrudePathFinalMeters { get; set; }

    public virtual DbSet<VwCrudePathingOverviewInfo> VwCrudePathingOverviewInfos { get; set; }

    public virtual DbSet<VwDealConfirmationInfo> VwDealConfirmationInfos { get; set; }

    public virtual DbSet<VwDealOverviewInfo> VwDealOverviewInfos { get; set; }

    public virtual DbSet<VwGasPathFinalMeter> VwGasPathFinalMeters { get; set; }

    public virtual DbSet<VwGasPathingOverviewInfo> VwGasPathingOverviewInfos { get; set; }

    public virtual DbSet<VwIndexOverviewInfo> VwIndexOverviewInfos { get; set; }

    public virtual DbSet<VwInvoiceCrude> VwInvoiceCrudes { get; set; }

    public virtual DbSet<VwInvoiceGa> VwInvoiceGas { get; set; }

    public virtual DbSet<VwMeterOverviewInfo> VwMeterOverviewInfos { get; set; }

    public virtual DbSet<VwMeterPointCrude> VwMeterPointCrudes { get; set; }

    public virtual DbSet<VwMeterPointGa> VwMeterPointGas { get; set; }

    public virtual DbSet<VwPaymentInstructionOverviewInfo> VwPaymentInstructionOverviewInfos { get; set; }

    public virtual DbSet<VwPipeContractOverviewInfo> VwPipeContractOverviewInfos { get; set; }

    public virtual DbSet<VwPipeRateScheduleOverviewInfo> VwPipeRateScheduleOverviewInfos { get; set; }

    public virtual DbSet<VwPipelineOverviewInfo> VwPipelineOverviewInfos { get; set; }

    public virtual DbSet<VwPlantStatementOverviewInfo> VwPlantStatementOverviewInfos { get; set; }

    public virtual DbSet<VwPointOverviewInfo> VwPointOverviewInfos { get; set; }

    public virtual DbSet<VwRptCounterparty> VwRptCounterparties { get; set; }

    public virtual DbSet<VwRptCreditLimit> VwRptCreditLimits { get; set; }

    public virtual DbSet<VwRptDailyIndexPrice> VwRptDailyIndexPrices { get; set; }

    public virtual DbSet<VwRptDeal> VwRptDeals { get; set; }

    public virtual DbSet<VwRptForwardIndexPrice> VwRptForwardIndexPrices { get; set; }

    public virtual DbSet<VwRptMeterDatum> VwRptMeterData { get; set; }

    public virtual DbSet<VwRptMonthlyIndexPrice> VwRptMonthlyIndexPrices { get; set; }

    public virtual DbSet<VwRptPlantStatement> VwRptPlantStatements { get; set; }

    public virtual DbSet<VwRptValuationDataDeal> VwRptValuationDataDeals { get; set; }

    public virtual DbSet<VwSalesTaxOverviewInfo> VwSalesTaxOverviewInfos { get; set; }

    public virtual DbSet<VwSeveranceTaxOverviewInfo> VwSeveranceTaxOverviewInfos { get; set; }

    public virtual DbSet<VwUserOverviewInfo> VwUserOverviewInfos { get; set; }

    public virtual DbSet<VwValDeal> VwValDeals { get; set; }

    public virtual DbSet<VwValDealVolume> VwValDealVolumes { get; set; }

    public virtual DbSet<W9Form> W9Forms { get; set; }

    public virtual DbSet<W9FormDoc> W9FormDocs { get; set; }

    public virtual DbSet<Zone> Zones { get; set; }

    protected override void OnModelCreating(ModelBuilder modelBuilder)
    {
        modelBuilder
            .HasPostgresExtension("citext")
            .HasPostgresExtension("pg_stat_statements");

        modelBuilder.Entity<ActualType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_actual_type");

            entity.Property(e => e.Id).ValueGeneratedNever();
        });

        modelBuilder.Entity<ActualizationFilter>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_actualization_filter");

            entity.HasOne(d => d.Product).WithMany(p => p.ActualizationFilters)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_actualization_filter_product");
        });

        modelBuilder.Entity<AppSetting>(entity =>
        {
            entity.HasKey(e => e.Name).HasName("pk_app_setting");
        });

        modelBuilder.Entity<AppUser>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_app_user");

            entity.HasIndex(e => e.NormalizedUserName, "ix_app_user_user_name")
                .IsUnique()
                .HasFilter("(normalized_user_name IS NOT NULL)");

            entity.Property(e => e.Id).HasDefaultValueSql("nextval('\"app_user_Id_seq\"'::regclass)");
            entity.Property(e => e.Theme).HasDefaultValueSql("'t1'::citext");

            entity.HasMany(d => d.Roles).WithMany(p => p.Users)
                .UsingEntity<Dictionary<string, object>>(
                    "AspUserRole",
                    r => r.HasOne<AspRole>().WithMany()
                        .HasForeignKey("RoleId")
                        .HasConstraintName("fk_asp_user_role_role"),
                    l => l.HasOne<AppUser>().WithMany()
                        .HasForeignKey("UserId")
                        .HasConstraintName("fk_asp_user_role_user"),
                    j =>
                    {
                        j.HasKey("UserId", "RoleId").HasName("pk_asp_user_role");
                        j.ToTable("asp_user_role");
                        j.HasIndex(new[] { "RoleId" }, "ix_asp_user_role_role_id");
                    });
        });

        modelBuilder.Entity<AspRole>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_asp_role");

            entity.HasIndex(e => e.NormalizedName, "uk_asp_role")
                .IsUnique()
                .HasFilter("(\"NormalizedName\" IS NOT NULL)");

            entity.Property(e => e.Id).HasDefaultValueSql("nextval('\"AspNetRoles_Id_seq\"'::regclass)");
        });

        modelBuilder.Entity<AspRoleClaim>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_asp_role_claim");

            entity.Property(e => e.Id).HasDefaultValueSql("nextval('\"AspNetRoleClaims_Id_seq\"'::regclass)");

            entity.HasOne(d => d.Role).WithMany(p => p.AspRoleClaims).HasConstraintName("fk_asp_role_claim_role");
        });

        modelBuilder.Entity<AspUserClaim>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_asp_user_claim");

            entity.Property(e => e.Id).HasDefaultValueSql("nextval('\"AspNetUserClaims_Id_seq\"'::regclass)");

            entity.HasOne(d => d.User).WithMany(p => p.AspUserClaims).HasConstraintName("fk_asp_user_claim_user");
        });

        modelBuilder.Entity<AspUserLogin>(entity =>
        {
            entity.HasKey(e => new { e.LoginProvider, e.ProviderKey }).HasName("pk_asp_user_login");

            entity.HasOne(d => d.User).WithMany(p => p.AspUserLogins).HasConstraintName("fk_asp_user_login_user");
        });

        modelBuilder.Entity<AspUserToken>(entity =>
        {
            entity.HasKey(e => new { e.UserId, e.LoginProvider, e.Name }).HasName("pk_asp_user_token");

            entity.HasOne(d => d.User).WithMany(p => p.AspUserTokens).HasConstraintName("fk_asp_user_token_user");
        });

        modelBuilder.Entity<BankRouting>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_bank_routing");

            entity.HasOne(d => d.AchState).WithMany(p => p.BankRoutingAchStates).HasConstraintName("fk_bank_routing_ach_state");

            entity.HasOne(d => d.WireState).WithMany(p => p.BankRoutingWireStates).HasConstraintName("fk_bank_routing_wire_state");
        });

        modelBuilder.Entity<Benchmark>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_benchmark_product_expiration_type");

            entity.Property(e => e.Id).ValueGeneratedNever();
        });

        modelBuilder.Entity<Book>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_internal_book");

            entity.Property(e => e.IsActive).HasDefaultValue(true);
        });

        modelBuilder.Entity<BookToTrader>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_map_book_to_trader");

            entity.HasOne(d => d.Book).WithMany(p => p.BookToTraders).HasConstraintName("fk_map_book_to_trader");

            entity.HasOne(d => d.Trader).WithMany(p => p.BookToTraders)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_book_to_trader_app_user");
        });

        modelBuilder.Entity<Broker>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_broker");

            entity.HasOne(d => d.BrokerState).WithMany(p => p.Brokers).HasConstraintName("fk_broker_state_name");
        });

        modelBuilder.Entity<BrokerAccount>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_broker_account");
        });

        modelBuilder.Entity<BrokerMemo>(entity =>
        {
            entity.HasKey(e => e.BrokerMemoId).HasName("pk_broker_memo");
        });

        modelBuilder.Entity<BusinessRelationship>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_business_relationship");

            entity.Property(e => e.Id).ValueGeneratedNever();
        });

        modelBuilder.Entity<BusinessSubType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_business_sub_type");

            entity.HasOne(d => d.BusinessType).WithMany(p => p.BusinessSubTypes).HasConstraintName("fk_business_sub_type_business_type");
        });

        modelBuilder.Entity<BusinessType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_business_type");
        });

        modelBuilder.Entity<BuySellType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_buy_sell_type");

            entity.Property(e => e.Id).ValueGeneratedNever();
        });

        modelBuilder.Entity<Calendar>(entity =>
        {
            entity.HasKey(e => e.Date).HasName("pk_calendar_date");
        });

        modelBuilder.Entity<CallPutType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_call_put_type");

            entity.Property(e => e.Id).ValueGeneratedNever();
        });

        modelBuilder.Entity<CollateralType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_collateral_type");
        });

        modelBuilder.Entity<Contact>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_contact");

            entity.Property(e => e.CountryId).HasDefaultValue(1);

            entity.HasOne(d => d.Country).WithMany(p => p.Contacts).HasConstraintName("fk_contact_country");

            entity.HasOne(d => d.State).WithMany(p => p.Contacts).HasConstraintName("fk_contact_state");
        });

        modelBuilder.Entity<ContactCounterparty>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_contact_counterparties");

            entity.HasOne(d => d.Contact).WithMany(p => p.ContactCounterparties).HasConstraintName("fk_contact_counterparties_contact");

            entity.HasOne(d => d.Counterparty).WithMany(p => p.ContactCounterparties)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_contact_counterparties_counterparty");
        });

        modelBuilder.Entity<ContactToContactType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_contact_types_map");

            entity.HasOne(d => d.Contact).WithMany(p => p.ContactToContactTypes).HasConstraintName("fk_contact_types_map");

            entity.HasOne(d => d.ContactType).WithMany(p => p.ContactToContactTypes)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_contact_types_map_contact_type");
        });

        modelBuilder.Entity<ContactType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_contact_type");

            entity.Property(e => e.Id).ValueGeneratedNever();
        });

        modelBuilder.Entity<Contract>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_contract");

            entity.Property(e => e.IsInternalSideOfContract).HasDefaultValue(false);
            entity.Property(e => e.IsPaymentNettingAllowed).HasDefaultValue(false);

            entity.HasOne(d => d.Counterparty).WithMany(p => p.ContractCounterparties)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_contract_counterparty");

            entity.HasOne(d => d.InternalEntity).WithMany(p => p.ContractInternalEntities)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_contract_internal_entity");

            entity.HasOne(d => d.PayFromBank).WithMany(p => p.ContractPayFromBanks).HasConstraintName("fk_contract_pay_from_bank_id");

            entity.HasOne(d => d.PayToBank).WithMany(p => p.ContractPayToBanks).HasConstraintName("fk_contract_pay_to_bank_id");

            entity.HasOne(d => d.Product).WithMany(p => p.Contracts)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_contract_product");

            entity.HasOne(d => d.Signer).WithMany(p => p.Contracts).HasConstraintName("fk_contract_signer_app_user");

            entity.HasOne(d => d.Status).WithMany(p => p.Contracts)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_contract_contract_status");
        });

        modelBuilder.Entity<ContractAccounting>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_contract_accounting");

            entity.Property(e => e.ChecksCountryId).HasDefaultValue(1);
            entity.Property(e => e.DoEmail).HasDefaultValue(false);
            entity.Property(e => e.DoFax).HasDefaultValue(false);
            entity.Property(e => e.InvoiceCountryId).HasDefaultValue(1);

            entity.HasOne(d => d.ChecksCountry).WithMany(p => p.ContractAccountingChecksCountries)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_contract_accounting_checks_country");

            entity.HasOne(d => d.ChecksState).WithMany(p => p.ContractAccountingChecksStates).HasConstraintName("fk_contract_accounting_checks_state");

            entity.HasOne(d => d.Contract).WithOne(p => p.ContractAccounting).HasConstraintName("fk_contract_accounting_contract");

            entity.HasOne(d => d.InvoiceCountry).WithMany(p => p.ContractAccountingInvoiceCountries)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_contract_accounting_invoice_country");

            entity.HasOne(d => d.InvoiceState).WithMany(p => p.ContractAccountingInvoiceStates).HasConstraintName("fk_contract_accounting_invoice_state");
        });

        modelBuilder.Entity<ContractContact>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_contract_contact");

            entity.Property(e => e.CombineEmail).HasDefaultValue(false);
            entity.Property(e => e.CommercialCountryId).HasDefaultValue(1);
            entity.Property(e => e.ConfirmationsCountryId).HasDefaultValue(1);
            entity.Property(e => e.CreditCountryId).HasDefaultValue(1);
            entity.Property(e => e.DoEmail).HasDefaultValue(false);
            entity.Property(e => e.DoFax).HasDefaultValue(false);
            entity.Property(e => e.NoticesCountryId).HasDefaultValue(1);
            entity.Property(e => e.SchedulingCountryId).HasDefaultValue(1);

            entity.HasOne(d => d.CommercialCountry).WithMany(p => p.ContractContactCommercialCountries)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_contract_contact_commercial_country");

            entity.HasOne(d => d.CommercialState).WithMany(p => p.ContractContactCommercialStates).HasConstraintName("fk_contract_contact_commercial_state");

            entity.HasOne(d => d.ConfirmationsCountry).WithMany(p => p.ContractContactConfirmationsCountries)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_contract_contact_confirmations_country");

            entity.HasOne(d => d.ConfirmationsState).WithMany(p => p.ContractContactConfirmationsStates).HasConstraintName("fk_contract_contact_confirmations_state");

            entity.HasOne(d => d.Contract).WithOne(p => p.ContractContact).HasConstraintName("fk_contract_contact_contract");

            entity.HasOne(d => d.CreditCountry).WithMany(p => p.ContractContactCreditCountries)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_contract_contact_credit_country");

            entity.HasOne(d => d.CreditState).WithMany(p => p.ContractContactCreditStates).HasConstraintName("fk_contract_contact_credit_state");

            entity.HasOne(d => d.NoticesCountry).WithMany(p => p.ContractContactNoticesCountries)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_contract_contact_notices_country");

            entity.HasOne(d => d.NoticesState).WithMany(p => p.ContractContactNoticesStates).HasConstraintName("fk_contract_contact_notices_state");

            entity.HasOne(d => d.SchedulingCountry).WithMany(p => p.ContractContactSchedulingCountries)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_contract_contact_scheduling_country");

            entity.HasOne(d => d.SchedulingState).WithMany(p => p.ContractContactSchedulingStates).HasConstraintName("fk_contract_contact_scheduling_state");
        });

        modelBuilder.Entity<ContractCrude>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_contract_crude");

            entity.Property(e => e.IsDiffBeforePipeLoss).HasDefaultValue(false);

            entity.HasOne(d => d.Contract).WithMany(p => p.ContractCrudes).HasConstraintName("fk_contract_crude");
        });

        modelBuilder.Entity<ContractCrudePoint>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_contract_crude_point");

            entity.HasOne(d => d.ContractCrude).WithMany(p => p.ContractCrudePoints).HasConstraintName("fk_contract_crude_point");
        });

        modelBuilder.Entity<ContractDoc>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_contract_doc");

            entity.HasOne(d => d.Contract).WithMany(p => p.ContractDocs).HasConstraintName("fk_contract_doc");
        });

        modelBuilder.Entity<ContractExhibitB>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_contract_exhibit_b");

            entity.HasOne(d => d.Contract).WithMany(p => p.ContractExhibitBs)
                .OnDelete(DeleteBehavior.Cascade)
                .HasConstraintName("fk_contract_exhibit_b_contract");

            entity.HasOne(d => d.Parent).WithMany(p => p.InverseParent).HasConstraintName("fk_contract_exhibit_b_parent");
        });

        modelBuilder.Entity<ContractExhibitBSelection>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_contract_exhibit_b_selection");

            entity.HasOne(d => d.ContractExhibitB).WithMany(p => p.ContractExhibitBSelections).HasConstraintName("fk_contract_exhibit_b_selection_exhibit_b");

            entity.HasOne(d => d.Contract).WithMany(p => p.ContractExhibitBSelections)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_contract_exhibit_b_selection_contract");
        });

        modelBuilder.Entity<ContractExhibitC>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_contract_exhibit_c");

            entity.Property(e => e.CheckPaymentCountryId).HasDefaultValue(1);

            entity.HasOne(d => d.CheckPaymentCountry).WithMany(p => p.ContractExhibitCs)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_contract_exhibit_c_check_payment_country");

            entity.HasOne(d => d.CheckPaymentState).WithMany(p => p.ContractExhibitCs).HasConstraintName("fk_contract_exhibit_c_check_payment_state");

            entity.HasOne(d => d.Contract).WithOne(p => p.ContractExhibitC).HasConstraintName("fk_contract_exhibit_c_contract");
        });

        modelBuilder.Entity<ContractNaesb>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_contract_naesb");

            entity.Property(e => e.AchPayment).HasDefaultValue(false);
            entity.Property(e => e.AddendumExhibitB).HasDefaultValue(false);
            entity.Property(e => e.AddendumExhibitC).HasDefaultValue(false);
            entity.Property(e => e.AddendumExhibitD).HasDefaultValue(false);
            entity.Property(e => e.AddendumExhibitE).HasDefaultValue(false);
            entity.Property(e => e.AddendumExhibitF).HasDefaultValue(false);
            entity.Property(e => e.AddendumExhibitG).HasDefaultValue(false);
            entity.Property(e => e.AddendumExhibitH).HasDefaultValue(false);
            entity.Property(e => e.AddendumExhibitI).HasDefaultValue(false);
            entity.Property(e => e.AddendumExhibitJ).HasDefaultValue(false);
            entity.Property(e => e.AddendumExhibitK).HasDefaultValue(false);
            entity.Property(e => e.AddendumExhibitL).HasDefaultValue(false);
            entity.Property(e => e.CheckPayment).HasDefaultValue(false);
            entity.Property(e => e.WireTransferPayment).HasDefaultValue(false);

            entity.HasOne(d => d.Contract).WithOne(p => p.ContractNaesb).HasConstraintName("fk_contract_naesb_contract");

            entity.HasOne(d => d.PaymentDateOption).WithMany(p => p.ContractNaesbs).HasConstraintName("fk_contract_naesb_payment_date_option");

            entity.HasOne(d => d.PaymentDateType).WithMany(p => p.ContractNaesbs).HasConstraintName("fk_contract_naesb_payment_date_type");
        });

        modelBuilder.Entity<ContractOther>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_contract_other");

            entity.HasOne(d => d.Contract).WithOne(p => p.ContractOther).HasConstraintName("fk_contract_other");
        });

        modelBuilder.Entity<ContractPaymentType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_contract_payment_type");

            entity.Property(e => e.Id).ValueGeneratedNever();
            entity.Property(e => e.IsWire).HasDefaultValue(false);
        });

        modelBuilder.Entity<ContractStatus>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_contract_status");

            entity.Property(e => e.Id).ValueGeneratedNever();
        });

        modelBuilder.Entity<Counterparty>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_counterparty");

            entity.Property(e => e.CountryId).HasDefaultValue(1);

            entity.HasOne(d => d.BusinessSubType).WithMany(p => p.Counterparties).HasConstraintName("fk_counterparty_business_sub_type");

            entity.HasOne(d => d.BusinessType).WithMany(p => p.Counterparties).HasConstraintName("fk_counterparty_business_type");

            entity.HasOne(d => d.Country).WithMany(p => p.Counterparties)
                .OnDelete(DeleteBehavior.Cascade)
                .HasConstraintName("fk_counterparty_country");

            entity.HasOne(d => d.HqLocation).WithMany(p => p.CounterpartyHqLocations).HasConstraintName("fk_counterparty_hq_location");

            entity.HasOne(d => d.Industry).WithMany(p => p.Counterparties)
                .OnDelete(DeleteBehavior.Cascade)
                .HasConstraintName("fk_counterparty_industry");

            entity.HasOne(d => d.Jurisdiction).WithMany(p => p.CounterpartyJurisdictions).HasConstraintName("fk_counterparty_jurisdiction");

            entity.HasOne(d => d.State).WithMany(p => p.CounterpartyStates).HasConstraintName("fk_counterparty_state");
        });

        modelBuilder.Entity<CounterpartyDun>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_counterparty_duns");

            entity.HasOne(d => d.Counterparty).WithMany(p => p.CounterpartyDuns).HasConstraintName("fk_counterparty_duns_counterparty");
        });

        modelBuilder.Entity<CounterpartyParent>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_counterparty_parent");

            entity.Property(e => e.OwnershipPercent).HasDefaultValueSql("'100'::numeric");

            entity.HasOne(d => d.Counterparty).WithMany(p => p.CounterpartyParentCounterparties).HasConstraintName("fk_counterparty_parent_counterparty");

            entity.HasOne(d => d.Parent).WithMany(p => p.CounterpartyParentParents)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_counterparty_parent_parent");
        });

        modelBuilder.Entity<CounterpartyProduct>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_counterparty_product");

            entity.HasOne(d => d.Counterparty).WithMany(p => p.CounterpartyProducts).HasConstraintName("fk_counterparty_product_counterparty");

            entity.HasOne(d => d.Product).WithMany(p => p.CounterpartyProducts)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_counterparty_product_product");
        });

        modelBuilder.Entity<CounterpartyRelationship>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_counterparty_relationship");

            entity.HasOne(d => d.BusinessRelationship).WithMany(p => p.CounterpartyRelationships).HasConstraintName("fk_counterparty_relationship_business_relationship");

            entity.HasOne(d => d.Counterparty).WithMany(p => p.CounterpartyRelationships).HasConstraintName("fk_counterparty_relationship_counterparty");
        });

        modelBuilder.Entity<Country>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_country");
        });

        modelBuilder.Entity<County>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_county");

            entity.HasOne(d => d.State).WithMany(p => p.Counties).HasConstraintName("fk_county_state_name");
        });

        modelBuilder.Entity<CreditLimit>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_credit_limit");

            entity.Property(e => e.IsOverLimitException).HasDefaultValue(false);

            entity.HasOne(d => d.ParentCounterparty).WithMany(p => p.CreditLimits)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_credit_limit_parent_counterparty");
        });

        modelBuilder.Entity<CreditLimitApproval>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_credit_limit_approval");

            entity.HasOne(d => d.CreditLimit).WithMany(p => p.CreditLimitApprovals).HasConstraintName("fk_credit_limit_approval_credit_limit");
        });

        modelBuilder.Entity<CreditLimitCollateral>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_credit_limit_collateral");

            entity.Property(e => e.IsAmendment).HasDefaultValue(false);

            entity.HasOne(d => d.CollateralType).WithMany(p => p.CreditLimitCollaterals)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_credit_limit_collateral_collateral_type");

            entity.HasOne(d => d.CreditLimitCounterparty).WithMany(p => p.CreditLimitCollaterals).HasConstraintName("fk_credit_limit_collateral");
        });

        modelBuilder.Entity<CreditLimitCollateralBeneficiary>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_credit_limit_collateral_beneficiary");

            entity.HasOne(d => d.Beneficiary).WithMany(p => p.CreditLimitCollateralBeneficiaries)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_credit_limit_collateral_beneficiary_beneficiary");

            entity.HasOne(d => d.CreditLimitCollateral).WithMany(p => p.CreditLimitCollateralBeneficiaries).HasConstraintName("fk_credit_limit_collateral_beneficiary");
        });

        modelBuilder.Entity<CreditLimitCollateralDoc>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_credit_limit_collateral_doc");

            entity.HasOne(d => d.CreditLimitCollateral).WithMany(p => p.CreditLimitCollateralDocs).HasConstraintName("fk_credit_limit_collateral_doc");
        });

        modelBuilder.Entity<CreditLimitCollateralProvider>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_credit_limit_collateral_provider");

            entity.HasOne(d => d.CreditLimitCollateral).WithMany(p => p.CreditLimitCollateralProviders).HasConstraintName("fk_credit_limit_collateral_provider_collateral");

            entity.HasOne(d => d.Provider).WithMany(p => p.CreditLimitCollateralProviders)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_credit_limit_collateral_provider_counterparty");
        });

        modelBuilder.Entity<CreditLimitCounterparty>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_credit_limit_counterparty");

            entity.HasOne(d => d.Counterparty).WithMany(p => p.CreditLimitCounterparties)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_credit_limit_counterparty_counterparty");

            entity.HasOne(d => d.CreditLimit).WithMany(p => p.CreditLimitCounterparties).HasConstraintName("fk_credit_limit_counterparty_credit_limit");

            entity.HasOne(d => d.ProductCategory).WithMany(p => p.CreditLimitCounterparties)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_credit_limit_counterparty_product_category");
        });

        modelBuilder.Entity<CrudeActual>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("idx_26396_pk_crude_actual");

            entity.Property(e => e.IsLinked).HasDefaultValue(true);

            entity.HasOne(d => d.ActualType).WithMany(p => p.CrudeActuals)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_crude_actual_type");

            entity.HasOne(d => d.LastTransfer).WithMany(p => p.CrudeActuals).HasConstraintName("fk_crude_actual_last_transfer");

            entity.HasOne(d => d.MarketNom).WithMany(p => p.CrudeActuals)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_crude_actual_market_nom");

            entity.HasOne(d => d.SavedByNavigation).WithMany(p => p.CrudeActuals)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_crude_actual_saved_app_user");

            entity.HasOne(d => d.SupplyNom).WithMany(p => p.CrudeActuals)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_crude_actual_supply_nom");

            entity.HasOne(d => d.TneMeter).WithMany(p => p.CrudeActuals).HasConstraintName("fk_crude_actual_tne_meter");
        });

        modelBuilder.Entity<CrudeMarket>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_crude_market");

            entity.Property(e => e.Month).HasComputedColumnSql("(date_trunc('month'::text, (date)::timestamp without time zone))::date", true);

            entity.HasOne(d => d.Deal).WithMany(p => p.CrudeMarkets).HasConstraintName("fk_crude_market_deal");

            entity.HasOne(d => d.Meter).WithMany(p => p.CrudeMarkets)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_crude_market_meter");

            entity.HasOne(d => d.Point).WithMany(p => p.CrudeMarkets).HasConstraintName("fk_crude_market_point");

            entity.HasOne(d => d.TransferDeal).WithMany(p => p.CrudeMarkets).HasConstraintName("fk_crude_market_transfer_deal");
        });

        modelBuilder.Entity<CrudeMarketSupply>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_crude_market_supply");

            entity.Property(e => e.IsActual).HasDefaultValue(false);
            entity.Property(e => e.IsKeepWhole).HasDefaultValue(false);

            entity.HasOne(d => d.MarketNom).WithMany(p => p.CrudeMarketSupplies).HasConstraintName("fk_crude_market_supply_market");

            entity.HasOne(d => d.SupplyNom).WithMany(p => p.CrudeMarketSupplies).HasConstraintName("fk_crude_market_supply_supply");
        });

        modelBuilder.Entity<CrudePath>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_crude_path");

            entity.Property(e => e.IsPathByMeter).HasDefaultValue(false);

            entity.HasOne(d => d.SourceCounterparty).WithMany(p => p.CrudePaths).HasConstraintName("fk_crude_path_entity");

            entity.HasOne(d => d.SourceMeter).WithMany(p => p.CrudePaths)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_crude_path_meter");

            entity.HasOne(d => d.SourcePipeContract).WithMany(p => p.CrudePaths).HasConstraintName("fk_crude_path_source_pipeline_contract");
        });

        modelBuilder.Entity<CrudePathRoute>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_crude_path_route");

            entity.Property(e => e.IsMeter1First).HasDefaultValue(true);

            entity.HasOne(d => d.MeterMap).WithMany(p => p.CrudePathRoutes)
                .OnDelete(DeleteBehavior.Cascade)
                .HasConstraintName("fk_crude_path_route_transfer_meter_map");

            entity.HasOne(d => d.Path).WithMany(p => p.CrudePathRoutes).HasConstraintName("fk_crude_path_route_crude_path");

            entity.HasOne(d => d.Point).WithMany(p => p.CrudePathRoutes)
                .OnDelete(DeleteBehavior.Cascade)
                .HasConstraintName("fk_crude_path_route_point");

            entity.HasOne(d => d.ToPipeContract).WithMany(p => p.CrudePathRoutes).HasConstraintName("fk_crude_path_route_pipeline_contract");
        });

        modelBuilder.Entity<CrudeSupply>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_crude_supply");

            entity.HasOne(d => d.CreatedByNavigation).WithMany(p => p.CrudeSupplyCreatedByNavigations)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_crude_supply_created_app_user");

            entity.HasOne(d => d.Deal).WithMany(p => p.CrudeSupplies).HasConstraintName("fk_crude_supply_deal");

            entity.HasOne(d => d.Duns).WithMany(p => p.CrudeSupplies)
                .OnDelete(DeleteBehavior.SetNull)
                .HasConstraintName("fk_crude_supply_duns_number");

            entity.HasOne(d => d.Meter).WithMany(p => p.CrudeSupplyMeters).HasConstraintName("fk_crude_supply_meter");

            entity.HasOne(d => d.PipelineContract).WithMany(p => p.CrudeSupplyPipelineContracts).HasConstraintName("fk_crude_supply_pipeline_contract");

            entity.HasOne(d => d.Point).WithMany(p => p.CrudeSupplies).HasConstraintName("fk_crude_supply_point");

            entity.HasOne(d => d.PtrDeliveryMeter).WithMany(p => p.CrudeSupplyPtrDeliveryMeters).HasConstraintName("fk_crude_supply_ptr_delivery_meter");

            entity.HasOne(d => d.PtrPipelineContract).WithMany(p => p.CrudeSupplyPtrPipelineContracts).HasConstraintName("fk_crude_supply_pipeline_contract_1");

            entity.HasOne(d => d.SavedByNavigation).WithMany(p => p.CrudeSupplySavedByNavigations)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_crude_supply_saved_app_user");

            entity.HasOne(d => d.TransferDeal).WithMany(p => p.CrudeSupplies).HasConstraintName("fk_crude_supply_transfer_deal");
        });

        modelBuilder.Entity<CurrencyType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_currency_type");

            entity.Property(e => e.Id).ValueGeneratedNever();
        });

        modelBuilder.Entity<Deal>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_deal");

            entity.Property(e => e.AttachLcLanguage).HasDefaultValue(false);
            entity.Property(e => e.DealStatusId).HasDefaultValue(1);
            entity.Property(e => e.HypotheticalId).HasDefaultValue(0);
            entity.Property(e => e.IsNetback).HasDefaultValue(false);
            entity.Property(e => e.IsPooledFutureDeal).HasDefaultValue(0);
            entity.Property(e => e.IsVariableVolume).HasDefaultValue(false);
            entity.Property(e => e.PriceIndexId2Sign).HasDefaultValue(1);
            entity.Property(e => e.PriceIndexIdSign).HasDefaultValue(1);
            entity.Property(e => e.SettleTypeId).HasDefaultValue(2);
            entity.Property(e => e.TicketNumber).HasComputedColumnSql("(SUBSTRING(ticket_num FROM 4))::integer", true);
            entity.Property(e => e.VolumeTypeId).HasDefaultValue(0);

            entity.HasOne(d => d.Book).WithMany(p => p.Deals).HasConstraintName("fk_deal_book");

            entity.HasOne(d => d.BrokerAccount).WithMany(p => p.Deals).HasConstraintName("fk_deal_broker_account");

            entity.HasOne(d => d.Broker).WithMany(p => p.Deals).HasConstraintName("fk_deal_broker");

            entity.HasOne(d => d.BuyButtonNavigation).WithMany(p => p.Deals).HasConstraintName("fk_deal_buy_sell_type");

            entity.HasOne(d => d.Contact).WithMany(p => p.Deals).HasConstraintName("fk_deal_contact_info");

            entity.HasOne(d => d.CostFuelCalculationType).WithMany(p => p.Deals).HasConstraintName("fk_deal_cost_fuel_calculation_type");

            entity.HasOne(d => d.Counterparty).WithMany(p => p.DealCounterparties).HasConstraintName("fk_deal_counterparty");

            entity.HasOne(d => d.CreatedByNavigation).WithMany(p => p.DealCreatedByNavigations).HasConstraintName("fk_deal_created_app_user");

            entity.HasOne(d => d.DealPurpose).WithMany(p => p.Deals).HasConstraintName("fk_deal_deal_purpose_type");

            entity.HasOne(d => d.DealStatus).WithMany(p => p.Deals)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_deal_deal_status");

            entity.HasOne(d => d.DeliveryMode).WithMany(p => p.Deals).HasConstraintName("fk_deal_delivery_mode");

            entity.HasOne(d => d.Hypothetical).WithMany(p => p.Deals)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_deal_hypothetical_type");

            entity.HasOne(d => d.InternalEntity).WithMany(p => p.DealInternalEntities).HasConstraintName("fk_deal_internal_entity");

            entity.HasOne(d => d.ModifiedByNavigation).WithMany(p => p.DealModifiedByNavigations).HasConstraintName("fk_deal_modified_app_user");

            entity.HasOne(d => d.PhysicalDealType).WithMany(p => p.Deals).HasConstraintName("fk_deal_physical_deal_type");

            entity.HasOne(d => d.PhysicalLink).WithMany(p => p.InversePhysicalLink).HasConstraintName("fk_deal_deal");

            entity.HasOne(d => d.Pipeline).WithMany(p => p.DealPipelines).HasConstraintName("fk_deal_pipeline");

            entity.HasOne(d => d.PipelineSourceDelivery).WithMany(p => p.DealPipelineSourceDeliveries).HasConstraintName("fk_deal_pipeline_1");

            entity.HasOne(d => d.Point).WithMany(p => p.Deals).HasConstraintName("fk_deal_point");

            entity.HasOne(d => d.Portfolio).WithMany(p => p.Deals).HasConstraintName("fk_deal_portfolio");

            entity.HasOne(d => d.PriceIndex).WithMany(p => p.DealPriceIndices).HasConstraintName("fk_deal_price_index_1");

            entity.HasOne(d => d.PriceIndexId2Navigation).WithMany(p => p.DealPriceIndexId2Navigations).HasConstraintName("fk_deal_price_index_2");

            entity.HasOne(d => d.Product).WithMany(p => p.Deals)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_deal_product");

            entity.HasOne(d => d.Region).WithMany(p => p.Deals).HasConstraintName("fk_deal_region");

            entity.HasOne(d => d.SettleType).WithMany(p => p.Deals).HasConstraintName("fk_deal_settle_type");

            entity.HasOne(d => d.Strategy).WithMany(p => p.Deals).HasConstraintName("fk_deal_strategy");

            entity.HasOne(d => d.Trader).WithMany(p => p.DealTraders).HasConstraintName("fk_deal_trader_app_user");

            entity.HasOne(d => d.TransactionType).WithMany(p => p.Deals).HasConstraintName("fk_deal_transaction_type");

            entity.HasOne(d => d.UnitBasisPrice).WithMany(p => p.DealUnitBasisPrices).HasConstraintName("fk_deal_unit_combination_1");

            entity.HasOne(d => d.UnitFixedPrice).WithMany(p => p.DealUnitFixedPrices).HasConstraintName("fk_deal_unit_combination");

            entity.HasOne(d => d.UnitOfMeasure).WithMany(p => p.Deals).HasConstraintName("fk_deal_unit_of_measure");

            entity.HasOne(d => d.UnitPremDiscPrice).WithMany(p => p.DealUnitPremDiscPrices).HasConstraintName("fk_deal_unit_combination_2");

            entity.HasOne(d => d.UnitTaxCredit).WithMany(p => p.DealUnitTaxCredits).HasConstraintName("fk_deal_unit_tax_credit");

            entity.HasOne(d => d.VolumeType).WithMany(p => p.Deals)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_deal_volume_type");
        });

        modelBuilder.Entity<DealConfirmation>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_deal_confirmation");

            entity.HasOne(d => d.ConfirmedByNavigation).WithMany(p => p.DealConfirmationConfirmedByNavigations).HasConstraintName("fk_deal_confirmation_confirmed_app_user");

            entity.HasOne(d => d.EmailedByNavigation).WithMany(p => p.DealConfirmationEmailedByNavigations).HasConstraintName("fk_deal_confirmation_emailed_app_user");

            entity.HasOne(d => d.FaxedByNavigation).WithMany(p => p.DealConfirmationFaxedByNavigations).HasConstraintName("fk_deal_confirmation_faxed_app_user");

            entity.HasOne(d => d.TicketNumNavigation).WithOne(p => p.DealConfirmation)
                .HasPrincipalKey<Deal>(p => p.TicketNum)
                .HasForeignKey<DealConfirmation>(d => d.TicketNum)
                .HasConstraintName("fk_deal_confirmation_deal");

            entity.HasOne(d => d.TicketedByNavigation).WithMany(p => p.DealConfirmationTicketedByNavigations).HasConstraintName("fk_deal_confirmation_ticketed_app_user");
        });

        modelBuilder.Entity<DealFilter>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_deal_filter");

            entity.Property(e => e.IsSelected).HasDefaultValue(false);

            entity.HasOne(d => d.User).WithMany(p => p.DealFilters).HasConstraintName("fk_deal_filter_app_user");
        });

        modelBuilder.Entity<DealFilterParameter>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_deal_filter_parameter");

            entity.HasOne(d => d.Filter).WithMany(p => p.DealFilterParameters).HasConstraintName("fk_deal_filter_parameter_deal_filter");
        });

        modelBuilder.Entity<DealPurposeType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_deal_purpose_type");

            entity.Property(e => e.Id).ValueGeneratedNever();
        });

        modelBuilder.Entity<DealStatus>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_deal_status");

            entity.Property(e => e.Id).ValueGeneratedNever();
        });

        modelBuilder.Entity<DealVolume>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_deal_volume");

            entity.HasOne(d => d.Deal).WithMany(p => p.DealVolumes).HasConstraintName("fk_deal_volume_deal");
        });

        modelBuilder.Entity<DeliveryMode>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_delivery_mode");

            entity.Property(e => e.Id).ValueGeneratedNever();
        });

        modelBuilder.Entity<DunsNumber>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_duns_number");

            entity.HasOne(d => d.Entity).WithMany(p => p.DunsNumbers).HasConstraintName("fk_duns_number_entity");
        });

        modelBuilder.Entity<EmailSetting>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_email_setting");

            entity.Property(e => e.ConnectionType).HasDefaultValue(0);
            entity.Property(e => e.Password).HasDefaultValueSql("''::citext");
            entity.Property(e => e.Port).HasDefaultValue(25);
            entity.Property(e => e.SmtpServer).HasDefaultValueSql("'localhost'::citext");
            entity.Property(e => e.UseAuthentication).HasDefaultValue(false);
            entity.Property(e => e.UseHtml).HasDefaultValue(false);
            entity.Property(e => e.UserName).HasDefaultValueSql("''::citext");
        });

        modelBuilder.Entity<Exchange>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_exchange");

            entity.Property(e => e.Id).ValueGeneratedNever();
        });

        modelBuilder.Entity<Favorite>(entity =>
        {
            entity.HasKey(e => e.UserId).HasName("pk_favorite");

            entity.Property(e => e.UserId).ValueGeneratedNever();

            entity.HasOne(d => d.User).WithOne(p => p.Favorite).HasConstraintName("fk_favorite_app_user");
        });

        modelBuilder.Entity<ForceMajeure>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_force_majeure");
        });

        modelBuilder.Entity<FuelCalculationType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_fuel_calculation_type");

            entity.Property(e => e.Id).ValueGeneratedNever();
        });

        modelBuilder.Entity<GasActual>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_gas_actual");

            entity.Property(e => e.IsLinked).HasDefaultValue(true);

            entity.HasOne(d => d.ActualType).WithMany(p => p.GasActuals)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_gas_actual_type");

            entity.HasOne(d => d.LastTransfer).WithMany(p => p.GasActuals).HasConstraintName("fk_gas_actual_last_transfer");

            entity.HasOne(d => d.MarketNom).WithMany(p => p.GasActuals)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_gas_actual_market_nom");

            entity.HasOne(d => d.SavedByNavigation).WithMany(p => p.GasActuals)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_gas_actual_saved_app_user");

            entity.HasOne(d => d.SupplyNom).WithMany(p => p.GasActuals)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_gas_actual_supply_nom");

            entity.HasOne(d => d.TneMeter).WithMany(p => p.GasActuals).HasConstraintName("fk_gas_actual_tne_meter");
        });

        modelBuilder.Entity<GasMarket>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_gas_market");

            entity.Property(e => e.Month).HasComputedColumnSql("(date_trunc('month'::text, (date)::timestamp without time zone))::date", true);

            entity.HasOne(d => d.Deal).WithMany(p => p.GasMarkets).HasConstraintName("fk_gas_market_deal");

            entity.HasOne(d => d.Meter).WithMany(p => p.GasMarkets)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_gas_market_meter");

            entity.HasOne(d => d.Point).WithMany(p => p.GasMarkets).HasConstraintName("fk_gas_market_point");

            entity.HasOne(d => d.TransferDeal).WithMany(p => p.GasMarkets).HasConstraintName("fk_gas_market_transfer_deal");
        });

        modelBuilder.Entity<GasMarketSupply>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_gas_market_supply");

            entity.Property(e => e.IsActual).HasDefaultValue(false);
            entity.Property(e => e.IsKeepWhole).HasDefaultValue(false);

            entity.HasOne(d => d.MarketNom).WithMany(p => p.GasMarketSupplies).HasConstraintName("fk_gas_market_supply_gas_market");

            entity.HasOne(d => d.SupplyNom).WithMany(p => p.GasMarketSupplies).HasConstraintName("fk_gas_market_supply_supply");
        });

        modelBuilder.Entity<GasPath>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_gas_path");

            entity.Property(e => e.IsPathByMeter).HasDefaultValue(false);

            entity.HasOne(d => d.SourceCounterparty).WithMany(p => p.GasPaths).HasConstraintName("fk_gas_path_entity");

            entity.HasOne(d => d.SourceMeter).WithMany(p => p.GasPaths)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_gas_path_meter");

            entity.HasOne(d => d.SourcePipeContract).WithMany(p => p.GasPaths).HasConstraintName("fk_gas_path_pipeline_contract");
        });

        modelBuilder.Entity<GasPathRoute>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_gas_path_route");

            entity.Property(e => e.IsMeter1First).HasDefaultValue(true);

            entity.HasOne(d => d.MeterMap).WithMany(p => p.GasPathRoutes)
                .OnDelete(DeleteBehavior.Cascade)
                .HasConstraintName("fk_gas_path_route_transfer_meter_map");

            entity.HasOne(d => d.Path).WithMany(p => p.GasPathRoutes).HasConstraintName("fk_gas_path_route");

            entity.HasOne(d => d.Point).WithMany(p => p.GasPathRoutes)
                .OnDelete(DeleteBehavior.Cascade)
                .HasConstraintName("fk_gas_path_route_point");

            entity.HasOne(d => d.ToPipeContract).WithMany(p => p.GasPathRoutes).HasConstraintName("fk_gas_path_route_pipeline_contract");
        });

        modelBuilder.Entity<GasSupply>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_gas_supply");

            entity.HasOne(d => d.CreatedByNavigation).WithMany(p => p.GasSupplyCreatedByNavigations)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_gas_supply_created_app_user");

            entity.HasOne(d => d.Deal).WithMany(p => p.GasSupplies).HasConstraintName("fk_supply_deal");

            entity.HasOne(d => d.Duns).WithMany(p => p.GasSupplies)
                .OnDelete(DeleteBehavior.SetNull)
                .HasConstraintName("fk_gas_supply_duns_number");

            entity.HasOne(d => d.Meter).WithMany(p => p.GasSupplyMeters).HasConstraintName("fk_gas_supply_meter");

            entity.HasOne(d => d.PipelineContract).WithMany(p => p.GasSupplyPipelineContracts).HasConstraintName("fk_gas_supply_pipeline_contract");

            entity.HasOne(d => d.Point).WithMany(p => p.GasSupplies).HasConstraintName("fk_supply_point");

            entity.HasOne(d => d.PtrDeliveryMeter).WithMany(p => p.GasSupplyPtrDeliveryMeters).HasConstraintName("fk_gas_supply_meter_1");

            entity.HasOne(d => d.PtrPipelineContract).WithMany(p => p.GasSupplyPtrPipelineContracts).HasConstraintName("fk_gas_supply_ptr_pipeline_contract");

            entity.HasOne(d => d.SavedByNavigation).WithMany(p => p.GasSupplySavedByNavigations)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_gas_supply_saved_app_user");

            entity.HasOne(d => d.TransferDeal).WithMany(p => p.GasSupplies).HasConstraintName("fk_supply_transfer_deal");
        });

        modelBuilder.Entity<Holiday>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_holiday");

            entity.Property(e => e.HolidayScheduleId).HasDefaultValue(1);
            entity.Property(e => e.IsWeekend).HasDefaultValue(false);

            entity.HasOne(d => d.HolidaySchedule).WithMany(p => p.Holidays)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_holidays_schedule");
        });

        modelBuilder.Entity<HolidaySchedule>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_holiday_schedule");

            entity.Property(e => e.Id).ValueGeneratedNever();
        });

        modelBuilder.Entity<HypotheticalType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_hypothetical_type");

            entity.Property(e => e.Id).ValueGeneratedNever();
        });

        modelBuilder.Entity<ImbalanceNomType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_imbalance_nom_type");
        });

        modelBuilder.Entity<Industry>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_industry");
        });

        modelBuilder.Entity<InvoiceCrude>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_invoice_crude");

            entity.Property(e => e.CreatedTime).HasDefaultValueSql("CURRENT_TIMESTAMP");
            entity.Property(e => e.InvoiceDate).HasDefaultValueSql("CURRENT_TIMESTAMP");
            entity.Property(e => e.InvoiceTypeId).HasDefaultValue(1);
            entity.Property(e => e.ModifiedTime).HasDefaultValueSql("CURRENT_TIMESTAMP");

            entity.HasOne(d => d.ContractPaymentType).WithMany(p => p.InvoiceCrudes).HasConstraintName("fk_invoice_crude_contract_payment_type");

            entity.HasOne(d => d.CounterpartyCountry).WithMany(p => p.InvoiceCrudeCounterpartyCountries).HasConstraintName("fk_invoice_crude_counterparty_country_1");

            entity.HasOne(d => d.Counterparty).WithMany(p => p.InvoiceCrudeCounterparties)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_invoice_crude_counterparty_1");

            entity.HasOne(d => d.CounterpartyState).WithMany(p => p.InvoiceCrudeCounterpartyStates).HasConstraintName("fk_invoice_crude_state_name_2");

            entity.HasOne(d => d.CreatedByNavigation).WithMany(p => p.InvoiceCrudeCreatedByNavigations)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_invoice_crude_created_by");

            entity.HasOne(d => d.EmailedByNavigation).WithMany(p => p.InvoiceCrudeEmailedByNavigations).HasConstraintName("fk_invoice_crude_emailed_app_user");

            entity.HasOne(d => d.InternalEntityCountry).WithMany(p => p.InvoiceCrudeInternalEntityCountries).HasConstraintName("fk_invoice_crude_internal_entity_country");

            entity.HasOne(d => d.InternalEntity).WithMany(p => p.InvoiceCrudeInternalEntities)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_invoice_crude_counterparty");

            entity.HasOne(d => d.InternalEntityState).WithMany(p => p.InvoiceCrudeInternalEntityStates).HasConstraintName("fk_invoice_crude_state_name_1");

            entity.HasOne(d => d.InvoiceType).WithMany(p => p.InvoiceCrudes)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_invoice_crude_invoice_type");

            entity.HasOne(d => d.ModifiedByNavigation).WithMany(p => p.InvoiceCrudeModifiedByNavigations)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_invoice_crude_modified_by");
        });

        modelBuilder.Entity<InvoiceCrudeLine>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_invoice_crude_line");

            entity.HasOne(d => d.ApprovedByNavigation).WithMany(p => p.InvoiceCrudeLines).HasConstraintName("fk_invoice_crude_line_approved_app_user");

            entity.HasOne(d => d.Deal).WithMany(p => p.InvoiceCrudeLines)
                .OnDelete(DeleteBehavior.Cascade)
                .HasConstraintName("fk_invoice_crude_line_deal");

            entity.HasOne(d => d.DeliveryMeter).WithMany(p => p.InvoiceCrudeLineDeliveryMeters).HasConstraintName("fk_invoice_crude_line_delivery_meter");

            entity.HasOne(d => d.Invoice).WithMany(p => p.InvoiceCrudeLines).HasConstraintName("fk_invoice_crude_line_invoice_crude");

            entity.HasOne(d => d.ReceiptMeter).WithMany(p => p.InvoiceCrudeLineReceiptMeters).HasConstraintName("fk_invoice_crude_line_receipt_meter");
        });

        modelBuilder.Entity<InvoiceGa>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_invoice_gas");

            entity.Property(e => e.CreatedTime).HasDefaultValueSql("CURRENT_TIMESTAMP");
            entity.Property(e => e.InvoiceDate).HasDefaultValueSql("CURRENT_TIMESTAMP");
            entity.Property(e => e.InvoiceTypeId).HasDefaultValue(1);
            entity.Property(e => e.ModifiedTime).HasDefaultValueSql("CURRENT_TIMESTAMP");

            entity.HasOne(d => d.ContractPaymentType).WithMany(p => p.InvoiceGas).HasConstraintName("fk_invoice_gas_contract_payment_type");

            entity.HasOne(d => d.CounterpartyCountry).WithMany(p => p.InvoiceGaCounterpartyCountries).HasConstraintName("fk_invoice_gas_country_1");

            entity.HasOne(d => d.Counterparty).WithMany(p => p.InvoiceGaCounterparties)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_invoice_gas_counterparty_1");

            entity.HasOne(d => d.CounterpartyState).WithMany(p => p.InvoiceGaCounterpartyStates).HasConstraintName("fk_invoice_gas_counterparty_state");

            entity.HasOne(d => d.CreatedByNavigation).WithMany(p => p.InvoiceGaCreatedByNavigations)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_invoice_gas_created_by");

            entity.HasOne(d => d.EmailedByNavigation).WithMany(p => p.InvoiceGaEmailedByNavigations).HasConstraintName("fk_invoice_gas_emailed_app_user");

            entity.HasOne(d => d.InternalEntityCountry).WithMany(p => p.InvoiceGaInternalEntityCountries).HasConstraintName("fk_invoice_gas_country");

            entity.HasOne(d => d.InternalEntity).WithMany(p => p.InvoiceGaInternalEntities)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_invoice_gas_counterparty");

            entity.HasOne(d => d.InternalEntityState).WithMany(p => p.InvoiceGaInternalEntityStates).HasConstraintName("fk_invoice_gas_internal_entity_state");

            entity.HasOne(d => d.InvoiceType).WithMany(p => p.InvoiceGas)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_invoice_gas_invoice_type");

            entity.HasOne(d => d.ModifiedByNavigation).WithMany(p => p.InvoiceGaModifiedByNavigations)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_invoice_gas_modified_by");
        });

        modelBuilder.Entity<InvoiceGasLine>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_invoice_gas_line");

            entity.HasOne(d => d.ApprovedByNavigation).WithMany(p => p.InvoiceGasLines).HasConstraintName("fk_invoice_gas_line_approved_app_user");

            entity.HasOne(d => d.Deal).WithMany(p => p.InvoiceGasLines)
                .OnDelete(DeleteBehavior.Cascade)
                .HasConstraintName("fk_invoice_gas_line_deal");

            entity.HasOne(d => d.Invoice).WithMany(p => p.InvoiceGasLines).HasConstraintName("fk_invoice_gas_line_invoice_gas");

            entity.HasOne(d => d.Meter).WithMany(p => p.InvoiceGasLines).HasConstraintName("fk_invoice_gas_line_meter");
        });

        modelBuilder.Entity<InvoiceType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_invoice_type");

            entity.Property(e => e.Id).ValueGeneratedNever();
        });

        modelBuilder.Entity<Lease>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_lease");

            entity.Property(e => e.LeaseTypeId).HasDefaultValue(3);

            entity.HasOne(d => d.LeaseType).WithMany(p => p.Leases)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_lease_lease_type");
        });

        modelBuilder.Entity<LeaseType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_lease_type");

            entity.Property(e => e.Id).ValueGeneratedNever();
        });

        modelBuilder.Entity<Location>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_location");
        });

        modelBuilder.Entity<MarketIndex>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_market_index");

            entity.Property(e => e.IndexTypeText).HasComputedColumnSql("\nCASE index_type_id\n    WHEN 0 THEN 'Daily'::text\n    WHEN 1 THEN 'Monthly'::text\n    WHEN 2 THEN 'Hybrid'::text\n    ELSE 'Unknown'::text\nEND", true);
            entity.Property(e => e.IsFutureDefault).HasDefaultValue(false);

            entity.HasOne(d => d.Product).WithMany(p => p.MarketIndices)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_market_index_product");

            entity.HasOne(d => d.Publication).WithMany(p => p.MarketIndices).HasConstraintName("fk_market_index_publication");

            entity.HasOne(d => d.UnitPrice).WithMany(p => p.MarketIndices)
                .OnDelete(DeleteBehavior.SetNull)
                .HasConstraintName("fk_market_index_unit_price_combination");
        });

        modelBuilder.Entity<MarketIndexAlias>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_market_index_alias");

            entity.HasOne(d => d.IndexAliasType).WithMany(p => p.MarketIndexAliases).HasConstraintName("fk_market_index_alias_index_alias_type");

            entity.HasOne(d => d.Index).WithMany(p => p.MarketIndexAliases).HasConstraintName("fk_market_index_alias_index");
        });

        modelBuilder.Entity<MarketIndexAliasType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_market_index_alias_type");

            entity.Property(e => e.Id).ValueGeneratedNever();
        });

        modelBuilder.Entity<MarketIndexClassificationType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_market_index_classification_type");

            entity.Property(e => e.Id).ValueGeneratedNever();
        });

        modelBuilder.Entity<MarketIndexPublication>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_market_index_publication");
        });

        modelBuilder.Entity<MarketIndexType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_market_index_type");
        });

        modelBuilder.Entity<MarketPrice>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_market_price");

            entity.Property(e => e.ContractMonth).HasDefaultValueSql("'1900-01-01'::date");

            entity.HasOne(d => d.DataInputer).WithMany(p => p.MarketPrices).HasConstraintName("fk_market_price_app_user");

            entity.HasOne(d => d.Index).WithMany(p => p.MarketPrices)
                .OnDelete(DeleteBehavior.Cascade)
                .HasConstraintName("fk_market_price_market_index");

            entity.HasOne(d => d.MarketType).WithMany(p => p.MarketPrices).HasConstraintName("fk_market_market_type");
        });

        modelBuilder.Entity<MarketType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_market_type");
        });

        modelBuilder.Entity<Meter>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_meter");

            entity.HasOne(d => d.Lease).WithMany(p => p.Meters).HasConstraintName("fk_meter_block");

            entity.HasOne(d => d.Location).WithMany(p => p.Meters).HasConstraintName("fk_meter_location");

            entity.HasOne(d => d.State).WithMany(p => p.Meters).HasConstraintName("fk_meter_state");
        });

        modelBuilder.Entity<MeterProduct>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_meter_product");

            entity.Property(e => e.IsUpstream).HasDefaultValue(false);

            entity.HasOne(d => d.Meter).WithMany(p => p.MeterProducts).HasConstraintName("fk_meter_product_meter");

            entity.HasOne(d => d.MeterType).WithMany(p => p.MeterProducts).HasConstraintName("fk_meter_product_meter_type");

            entity.HasOne(d => d.Product).WithMany(p => p.MeterProducts)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_meter_product_product");

            entity.HasOne(d => d.SourceZone).WithMany(p => p.MeterProducts).HasConstraintName("fk_meter_product_source_zone");
        });

        modelBuilder.Entity<MeterProductDeliveryPoint>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("meter_product_delivery_point_pkey");

            entity.HasOne(d => d.MeterProduct).WithMany(p => p.MeterProductDeliveryPoints).HasConstraintName("fk_meter_product_delivery_meter_product");

            entity.HasOne(d => d.Point).WithMany(p => p.MeterProductDeliveryPoints).HasConstraintName("fk_meter_product_delivery_point");
        });

        modelBuilder.Entity<MeterProductSourcePoint>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("meter_product_source_point_pkey");

            entity.HasOne(d => d.MeterProduct).WithMany(p => p.MeterProductSourcePoints).HasConstraintName("fk_meter_product_source_meter_product");

            entity.HasOne(d => d.Point).WithMany(p => p.MeterProductSourcePoints).HasConstraintName("fk_meter_product_source_point");
        });

        modelBuilder.Entity<MeterPtr>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_meter_ptr");

            entity.HasOne(d => d.Meter).WithMany(p => p.MeterPtrs).HasConstraintName("fk_meter_ptr_meter");
        });

        modelBuilder.Entity<MeterPtrExcluded>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_meter_ptr_excluded");

            entity.HasOne(d => d.Counterparty).WithMany(p => p.MeterPtrExcludeds).HasConstraintName("fk_meter_ptr_entity_public_info");

            entity.HasOne(d => d.MeterPtr).WithMany(p => p.MeterPtrExcludeds).HasConstraintName("fk_meter_ptr_excluded_meter_ptr");
        });

        modelBuilder.Entity<MeterType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_meter_type");

            entity.HasOne(d => d.DefaultUnitOfMeasure).WithMany(p => p.MeterTypes).HasConstraintName("fk_meter_type_unit_of_measure");
        });

        modelBuilder.Entity<Notification>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_notification");

            entity.Property(e => e.Id).ValueGeneratedNever();
        });

        modelBuilder.Entity<OpenIddictApplication>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_openiddict_applications");

            entity.HasIndex(e => e.ClientId, "idx_26788_IX_OpenIddictApplications_ClientId")
                .IsUnique()
                .HasFilter("(\"ClientId\" IS NOT NULL)");
        });

        modelBuilder.Entity<OpenIddictAuthorization>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_openiddict_authorizations");

            entity.HasOne(d => d.Application).WithMany(p => p.OpenIddictAuthorizations)
                .OnDelete(DeleteBehavior.Cascade)
                .HasConstraintName("fk_openiddict_authorizations_apps");
        });

        modelBuilder.Entity<OpenIddictScope>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_openiddict_scopes");

            entity.HasIndex(e => e.Name, "idx_26798_IX_OpenIddictScopes_Name")
                .IsUnique()
                .HasFilter("(\"Name\" IS NOT NULL)");
        });

        modelBuilder.Entity<OpenIddictToken>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_openiddict_tokens");

            entity.HasIndex(e => e.ReferenceId, "idx_26803_IX_OpenIddictTokens_ReferenceId")
                .IsUnique()
                .HasFilter("(\"ReferenceId\" IS NOT NULL)");

            entity.HasOne(d => d.Application).WithMany(p => p.OpenIddictTokens).HasConstraintName("fk_openiddict_tokens_applications_application_id");

            entity.HasOne(d => d.Authorization).WithMany(p => p.OpenIddictTokens).HasConstraintName("fk_openiddict_tokens_authorizations_authorization_id");
        });

        modelBuilder.Entity<Password>(entity =>
        {
            entity.HasKey(e => e.Name).HasName("pk_password_1");
        });

        modelBuilder.Entity<PaymentDateOption>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_payment_date_option");

            entity.Property(e => e.Id).ValueGeneratedNever();
        });

        modelBuilder.Entity<PaymentDateType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_payment_date_type");

            entity.Property(e => e.Id).ValueGeneratedNever();
        });

        modelBuilder.Entity<PaymentInstruction>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_payment_instruction");

            entity.Property(e => e.HasPaymentTypeCcd).HasDefaultValue(false);
            entity.Property(e => e.HasPaymentTypeCtx).HasDefaultValue(false);
            entity.Property(e => e.HasPaymentTypePpd).HasDefaultValue(false);
            entity.Property(e => e.HasPaymentTypeTax).HasDefaultValue(false);
            entity.Property(e => e.HasPaymentTypeWire).HasDefaultValue(false);

            entity.HasOne(d => d.BankAchState).WithMany(p => p.PaymentInstructionBankAchStates).HasConstraintName("fk_payment_instruction_bank_ach_state");

            entity.HasOne(d => d.BankState).WithMany(p => p.PaymentInstructionBankStates).HasConstraintName("fk_payment_instruction_bank_state");

            entity.HasOne(d => d.BankWireState).WithMany(p => p.PaymentInstructionBankWireStates).HasConstraintName("fk_payment_instruction_bank_wire_state");

            entity.HasOne(d => d.Counterparty).WithMany(p => p.PaymentInstructions)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_payment_instruction_counterparty");
        });

        modelBuilder.Entity<PaymentInstructionDoc>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_payment_instruction_doc");

            entity.HasOne(d => d.PaymentInstruction).WithMany(p => p.PaymentInstructionDocs).HasConstraintName("fk_payment_instruction_doc_payment_instruction");
        });

        modelBuilder.Entity<PayoutType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_payout_type");
        });

        modelBuilder.Entity<PhysicalDealType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_physical_deal_type");

            entity.Property(e => e.Id).ValueGeneratedNever();
        });

        modelBuilder.Entity<PipeContractDeliveryMeter>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_pipe_contract_delivery_meter");

            entity.HasOne(d => d.Meter).WithMany(p => p.PipeContractDeliveryMeters).HasConstraintName("fk_pipe_contract_delivery_meter_meter");

            entity.HasOne(d => d.PipeContract).WithMany(p => p.PipeContractDeliveryMeters).HasConstraintName("fk_pipe_contract_delivery_meter_pipeline_contract");
        });

        modelBuilder.Entity<PipeContractDeliveryZone>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_pipe_contract_delivery_zone");

            entity.HasOne(d => d.PipeContract).WithMany(p => p.PipeContractDeliveryZones).HasConstraintName("fk_pipe_contract_delivery_zone_pipeline_contract");

            entity.HasOne(d => d.Zone).WithMany(p => p.PipeContractDeliveryZones).HasConstraintName("fk_pipe_contract_delivery_zone_zone");
        });

        modelBuilder.Entity<PipeContractDoc>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_pipe_contract_doc");

            entity.HasOne(d => d.PipeContract).WithMany(p => p.PipeContractDocs).HasConstraintName("fk_pipe_contract_doc_pipeline_contract");
        });

        modelBuilder.Entity<PipeContractReceiptMeter>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_pipe_contract_receipt_meter");

            entity.HasOne(d => d.Meter).WithMany(p => p.PipeContractReceiptMeters).HasConstraintName("fk_pipe_contract_receipt_meter_meter");

            entity.HasOne(d => d.PipeContract).WithMany(p => p.PipeContractReceiptMeters).HasConstraintName("fk_pipe_contract_receipt_meter_pipeline_contract");
        });

        modelBuilder.Entity<PipeContractReceiptZone>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_pipe_contract_receipt_zone");

            entity.HasOne(d => d.PipeContract).WithMany(p => p.PipeContractReceiptZones).HasConstraintName("fk_pipe_contract_receipt_zone_pipeline_contract");

            entity.HasOne(d => d.Zone).WithMany(p => p.PipeContractReceiptZones).HasConstraintName("fk_pipe_contract_receipt_zone_zone");
        });

        modelBuilder.Entity<PipeDiscountDoc>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_pipe_discount_doc");

            entity.HasOne(d => d.PipelineRateDiscounted).WithMany(p => p.PipeDiscountDocs).HasConstraintName("fk_pipe_discount_doc_pipeline_rate_discounted");
        });

        modelBuilder.Entity<PipeRateApplicationRule>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_pipe_rate_application_rule");

            entity.Property(e => e.Id).ValueGeneratedNever();
        });

        modelBuilder.Entity<PipeRateDoc>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_pipe_rate_doc");

            entity.HasOne(d => d.PipelineTariff).WithMany(p => p.PipeRateDocs).HasConstraintName("fk_pipe_rate_doc_pipeline_tariff");
        });

        modelBuilder.Entity<Pipeline>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_pipeline");

            entity.Property(e => e.PipelineTypeId).HasDefaultValue(3);

            entity.HasOne(d => d.DefaultPtrPipelineContract).WithMany(p => p.Pipelines).HasConstraintName("fk_pipeline_default_ptr_contract");

            entity.HasOne(d => d.PipelineType).WithMany(p => p.Pipelines)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_pipeline_pipeline_type");
        });

        modelBuilder.Entity<PipelineContract>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_pipeline_contract");

            entity.Property(e => e.IsPtrContract).HasDefaultValue(false);

            entity.HasOne(d => d.ContractOwner).WithMany(p => p.PipelineContractContractOwners).HasConstraintName("fk_pipeline_contract_entity_public_info");

            entity.HasOne(d => d.ContractType).WithMany(p => p.PipelineContracts).HasConstraintName("fk_pipeline_contract_pipeline_contract_type");

            entity.HasOne(d => d.Counterparty).WithMany(p => p.PipelineContractCounterparties).HasConstraintName("fk_pipeline_contract_counterparty");

            entity.HasOne(d => d.ImbalanceNomType).WithMany(p => p.PipelineContracts).HasConstraintName("fk_pipeline_contract_imbalance_nom_type");

            entity.HasOne(d => d.InternalEntity).WithMany(p => p.PipelineContractInternalEntities).HasConstraintName("fk_pipeline_contract_internal_entity");

            entity.HasOne(d => d.OriginalCreationUser).WithMany(p => p.PipelineContracts).HasConstraintName("fk_pipeline_contract_app_user");

            entity.HasOne(d => d.Pipeline).WithMany(p => p.PipelineContracts)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_pipeline_contract_pipeline");

            entity.HasOne(d => d.Product).WithMany(p => p.PipelineContracts)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_pipe_contract_product");

            entity.HasOne(d => d.RateSchedule).WithMany(p => p.PipelineContracts).HasConstraintName("fk_pipeline_contract_pipeline_rate_schedule");

            entity.HasOne(d => d.TransactionType).WithMany(p => p.PipelineContracts).HasConstraintName("fk_pipeline_contract_transaction_type");
        });

        modelBuilder.Entity<PipelineContractDefault>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_pipeline_contract_default");

            entity.HasOne(d => d.PipeContract).WithMany(p => p.PipelineContractDefaults).HasConstraintName("fk_pipeline_contract_default_pipeline_contract");

            entity.HasOne(d => d.Pipeline).WithMany(p => p.PipelineContractDefaults).HasConstraintName("fk_pipeline_contract_default_pipeline");

            entity.HasOne(d => d.Product).WithMany(p => p.PipelineContractDefaults)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_pipeline_contract_default_product");
        });

        modelBuilder.Entity<PipelineContractType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_pipeline_contract_type");
        });

        modelBuilder.Entity<PipelineRateDiscounted>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_pipeline_rate_discounted");

            entity.Property(e => e.AreAllCounterpartySelected).HasDefaultValue(false);
            entity.Property(e => e.AreAllFromMetersSelected).HasDefaultValue(false);
            entity.Property(e => e.AreAllFromZonesSelected).HasDefaultValue(false);
            entity.Property(e => e.AreAllToMetersSelected).HasDefaultValue(false);
            entity.Property(e => e.AreAllToZonesSelected).HasDefaultValue(false);

            entity.HasOne(d => d.RateSchedule).WithMany(p => p.PipelineRateDiscounteds).HasConstraintName("fk_pipeline_rate_discounted_pipeline_rate_schedule");

            entity.HasOne(d => d.TariffType).WithMany(p => p.PipelineRateDiscounteds).HasConstraintName("fk_pipeline_rate_discounted_pipeline_tariff_discounted_rate");
        });

        modelBuilder.Entity<PipelineRateDiscountedCounterparty>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_pipeline_rate_discounted_counterparty");

            entity.HasOne(d => d.DiscountedRate).WithMany(p => p.PipelineRateDiscountedCounterparties).HasConstraintName("fk_pipeline_rate_discounted_counterparty");

            entity.HasOne(d => d.Entity).WithMany(p => p.PipelineRateDiscountedCounterparties).HasConstraintName("fk_pipeline_rate_discounted_counterparty_entity");
        });

        modelBuilder.Entity<PipelineRateDiscountedFromTo>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_pipeline_rate_discounted_from_to");

            entity.Property(e => e.IsFrom).HasDefaultValue(true);

            entity.HasOne(d => d.DiscountedRate).WithMany(p => p.PipelineRateDiscountedFromTos)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_pipeline_rate_discounted_from_to_pipeline_rate_discounted");

            entity.HasOne(d => d.Meter).WithMany(p => p.PipelineRateDiscountedFromTos)
                .OnDelete(DeleteBehavior.Cascade)
                .HasConstraintName("fk_pipeline_rate_discounted_from_to_meter");

            entity.HasOne(d => d.Zone).WithMany(p => p.PipelineRateDiscountedFromTos)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_pipeline_rate_discounted_from_to_zone");
        });

        modelBuilder.Entity<PipelineRateSchedule>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_pipeline_rate_schedule");

            entity.HasOne(d => d.ContractTypeNavigation).WithMany(p => p.PipelineRateSchedules)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_pipeline_rate_schedule_pipeline_contract_type");

            entity.HasOne(d => d.Pipeline).WithMany(p => p.PipelineRateSchedules)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_pipeline_rate_schedule_pipeline");

            entity.HasOne(d => d.Product).WithMany(p => p.PipelineRateSchedules)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_pipe_rate_schedule_product");
        });

        modelBuilder.Entity<PipelineTariff>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_pipeline_tariff");

            entity.Property(e => e.ApplicationRuleId).HasDefaultValue(1);

            entity.HasOne(d => d.ApplicationRule).WithMany(p => p.PipelineTariffs)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_pipeline_tariff_application_rule");

            entity.HasOne(d => d.RateSchedule).WithMany(p => p.PipelineTariffs).HasConstraintName("fk_pipeline_tariff_pipeline_rate_schedule");

            entity.HasOne(d => d.TariffType).WithMany(p => p.PipelineTariffs).HasConstraintName("fk_pipeline_tariff_pipeline_tariff_type");
        });

        modelBuilder.Entity<PipelineTariffDatum>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_pipeline_tariff_data");

            entity.HasOne(d => d.Tariff).WithMany(p => p.PipelineTariffData).HasConstraintName("fk_pipeline_tariff_data_pipeline_tariff");
        });

        modelBuilder.Entity<PipelineTariffType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_pipeline_tariff_type");

            entity.Property(e => e.Id).ValueGeneratedNever();
        });

        modelBuilder.Entity<PipelineType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_pipeline_type");

            entity.Property(e => e.Id).ValueGeneratedNever();
        });

        modelBuilder.Entity<Plant>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_plant");

            entity.Property(e => e.IsActive).HasDefaultValue(true);
        });

        modelBuilder.Entity<PlantNote>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_plant_note");

            entity.HasOne(d => d.Plant).WithMany(p => p.PlantNotes).HasConstraintName("fk_plant_note_plant");
        });

        modelBuilder.Entity<PlantStatement>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_plant_statement");

            entity.Property(e => e.ChargeProducerFee).HasDefaultValue(true);

            entity.HasOne(d => d.Meter).WithMany(p => p.PlantStatements).HasConstraintName("fk_plant_statement_meter");

            entity.HasOne(d => d.PayoutType).WithMany(p => p.PlantStatements).HasConstraintName("fk_plant_statement_payout_type");

            entity.HasOne(d => d.Plant).WithMany(p => p.PlantStatements)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_plant_statement_plant");

            entity.HasOne(d => d.Prices).WithMany(p => p.PlantStatements).HasConstraintName("fk_plant_statement_plant_statement_price");

            entity.HasOne(d => d.Producer).WithMany(p => p.PlantStatements)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_plant_statement_producer");

            entity.HasOne(d => d.StatementDescriptor).WithMany(p => p.PlantStatements).HasConstraintName("fk_plant_statement_plant_statement_descriptor");
        });

        modelBuilder.Entity<PlantStatementCombinedMeter>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_plant_statement_combined_meter");

            entity.HasOne(d => d.Meter).WithMany(p => p.PlantStatementCombinedMeters).HasConstraintName("fk_plant_statement_combined_meter_meter");

            entity.HasOne(d => d.PlantStatement).WithMany(p => p.PlantStatementCombinedMeters).HasConstraintName("fk_plant_statement_combined_meter_plant_statement");
        });

        modelBuilder.Entity<PlantStatementDescriptor>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_plant_statement_descriptor");
        });

        modelBuilder.Entity<PlantStatementOption>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_plant_statement_option");

            entity.HasOne(d => d.PayoutType).WithMany(p => p.PlantStatementOptions).HasConstraintName("fk_plant_statement_option_payout_type");

            entity.HasOne(d => d.Plant).WithMany(p => p.PlantStatementOptions)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_plant_statement_option_plant");
        });

        modelBuilder.Entity<PlantStatementPrice>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_plant_statement_price");

            entity.HasOne(d => d.Plant).WithMany(p => p.PlantStatementPrices)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_plant_statement_price_plant");

            entity.HasOne(d => d.Producer).WithMany(p => p.PlantStatementPrices)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_plant_statement_price_producer");
        });

        modelBuilder.Entity<Point>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_point");

            entity.Property(e => e.IsActive).HasDefaultValue(true);

            entity.HasOne(d => d.Pipeline).WithMany(p => p.Points).HasConstraintName("fk_point_pipeline");

            entity.HasOne(d => d.State).WithMany(p => p.Points)
                .OnDelete(DeleteBehavior.SetNull)
                .HasConstraintName("fk_point_state");

            entity.HasOne(d => d.Zone).WithMany(p => p.Points).HasConstraintName("fk_point_zone");
        });

        modelBuilder.Entity<PointProductGradeToIndex>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_point_product_grade_to_index");

            entity.HasOne(d => d.Point).WithMany(p => p.PointProductGradeToIndices)
                .OnDelete(DeleteBehavior.Cascade)
                .HasConstraintName("fk_point_product_grade_to_index_point");

            entity.HasOne(d => d.PostingIndex).WithMany(p => p.PointProductGradeToIndices).HasConstraintName("fk_point_product_grade_to_index_posting_index");

            entity.HasOne(d => d.Product).WithMany(p => p.PointProductGradeToIndices)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_point_product_grade_to_index_product");
        });

        modelBuilder.Entity<PointSourceDelivery>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_point_source_delivery");

            entity.HasOne(d => d.Deal).WithMany(p => p.PointSourceDeliveries).HasConstraintName("fk_point_source_delivery_deal");

            entity.HasOne(d => d.Point).WithMany(p => p.PointSourceDeliveries).HasConstraintName("fk_point_source_delivery_point");
        });

        modelBuilder.Entity<Portfolio>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_portfolio_name_list");

            entity.Property(e => e.IsActive).HasDefaultValue(true);
        });

        modelBuilder.Entity<ProducerFee>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_producer_fee");

            entity.HasOne(d => d.FeeType).WithMany(p => p.ProducerFees)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_producer_fee_fee_type");

            entity.HasOne(d => d.Producer).WithMany(p => p.ProducerFees)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_producer_fee_producer");
        });

        modelBuilder.Entity<ProducerFeeType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_producer_fee_type");

            entity.Property(e => e.Id).ValueGeneratedNever();
        });

        modelBuilder.Entity<Product>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_product");

            entity.HasOne(d => d.Category).WithMany(p => p.Products)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_product_product_category");

            entity.HasOne(d => d.UnitOfMeasure).WithMany(p => p.Products).HasConstraintName("fk_product_unit_of_measure");

            entity.HasOne(d => d.UnitPrice).WithMany(p => p.Products).HasConstraintName("fk_product_unit_price");
        });

        modelBuilder.Entity<ProductCategory>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_product_category");
        });

        modelBuilder.Entity<ProductExpiration>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_product_expiration");

            entity.HasOne(d => d.Benchmark).WithMany(p => p.ProductExpirations)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_product_expiration_benchmark");

            entity.HasOne(d => d.Product).WithMany(p => p.ProductExpirations)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_product_expiration_product");
        });

        modelBuilder.Entity<PublishedToInternalIndex>(entity =>
        {
            entity.HasKey(e => new { e.PublishedIndexId, e.InternalIndexId }).HasName("pk_published_to_internal_index");

            entity.HasOne(d => d.InternalIndex).WithMany(p => p.PublishedToInternalIndexInternalIndices)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_published_to_internal_index_price_index_type_1");

            entity.HasOne(d => d.PublishedIndex).WithOne(p => p.PublishedToInternalIndexPublishedIndex)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_published_to_internal_index_price_index_type");
        });

        modelBuilder.Entity<QualityBankAdjustment>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_quality_bank_adjustment");

            entity.HasOne(d => d.Contract).WithMany(p => p.QualityBankAdjustments)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_quality_bank_adjustment_contract");
        });

        modelBuilder.Entity<QualityBankAdjustmentDetail>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_quality_bank_adjustment_detail");

            entity.HasOne(d => d.QualityBankAdjustment).WithMany(p => p.QualityBankAdjustmentDetails).HasConstraintName("fk_quality_bank_adjustment_detail_quality_bank_adjustment");
        });

        modelBuilder.Entity<Region>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_region");

            entity.Property(e => e.IsActive).HasDefaultValue(true);
        });

        modelBuilder.Entity<Report>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_report");

            entity.Property(e => e.SaveAsPdf).HasDefaultValue(false);
        });

        modelBuilder.Entity<ReportDataSource>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_report_data_source");

            entity.Property(e => e.IsFilterRequired).HasDefaultValue(false);
        });

        modelBuilder.Entity<ReportFilter>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_report_filter");

            entity.Property(e => e.IsSelected).HasDefaultValue(false);

            entity.HasOne(d => d.Report).WithMany(p => p.ReportFilters).HasConstraintName("fk_report_filter_report");

            entity.HasOne(d => d.User).WithMany(p => p.ReportFilters).HasConstraintName("fk_report_filter_app_user");
        });

        modelBuilder.Entity<ReportFilterParameter>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_report_filter_parameter");

            entity.HasOne(d => d.DataSource).WithMany(p => p.ReportFilterParameters)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_report_filter_parameter_report_data_source");

            entity.HasOne(d => d.Filter).WithMany(p => p.ReportFilterParameters).HasConstraintName("fk_report_filter_parameter_report_filter");
        });

        modelBuilder.Entity<SalesTax>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_sales_tax");

            entity.HasOne(d => d.County).WithOne(p => p.SalesTax)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_sales_tax_county");
        });

        modelBuilder.Entity<SalesTaxDetail>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_sales_tax_detail");

            entity.HasOne(d => d.SalesTax).WithMany(p => p.SalesTaxDetails).HasConstraintName("fk_sales_tax_detail_sales_tax");

            entity.HasOne(d => d.TaxType).WithMany(p => p.SalesTaxDetails)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_sales_tax_detail_sales_tax_type");
        });

        modelBuilder.Entity<SalesTaxDoc>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_sales_tax_doc");

            entity.HasOne(d => d.SalesTax).WithMany(p => p.SalesTaxDocs).HasConstraintName("fk_sales_tax_doc_sales_tax");
        });

        modelBuilder.Entity<SalesTaxExemption>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_sales_tax_exemption");

            entity.HasOne(d => d.Company).WithMany(p => p.SalesTaxExemptions).HasConstraintName("fk_sales_tax_exemption_company");

            entity.HasOne(d => d.State).WithMany(p => p.SalesTaxExemptions).HasConstraintName("fk_sales_tax_exemption_state");
        });

        modelBuilder.Entity<SalesTaxExemptionDoc>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_sales_tax_exemption_doc");

            entity.HasOne(d => d.SalesTaxExemption).WithMany(p => p.SalesTaxExemptionDocs).HasConstraintName("fk_sales_tax_exemption_doc_sales_tax_exemption");
        });

        modelBuilder.Entity<SalesTaxRate>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_sales_tax_rate");

            entity.HasOne(d => d.County).WithMany(p => p.SalesTaxRates)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_sales_tax_rate_county");
        });

        modelBuilder.Entity<SalesTaxType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_sales_tax_type");

            entity.Property(e => e.Id).ValueGeneratedNever();
        });

        modelBuilder.Entity<Screen>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_screen");

            entity.Property(e => e.IsVisible).HasDefaultValue(true);

            entity.HasOne(d => d.Parent).WithMany(p => p.InverseParent).HasConstraintName("fk_screen_parent_screen");

            entity.HasOne(d => d.SecurityAction).WithMany(p => p.Screens).HasConstraintName("fk_screen_security_action");
        });

        modelBuilder.Entity<SecurityAction>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_security_action");

            entity.Property(e => e.IsView).HasDefaultValue(true);
        });

        modelBuilder.Entity<SecurityGroup>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_security_group");
        });

        modelBuilder.Entity<SecurityGroupPermission>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_security_group_permission");

            entity.Property(e => e.IsAllowed).HasDefaultValue(true);
            entity.Property(e => e.IsModifyAllowed).HasDefaultValue(true);
            entity.Property(e => e.IsViewAllowed).HasDefaultValue(true);

            entity.HasOne(d => d.SecurityAction).WithMany(p => p.SecurityGroupPermissions).HasConstraintName("fk_security_group_permission_security_action");

            entity.HasOne(d => d.SecurityGroup).WithMany(p => p.SecurityGroupPermissions).HasConstraintName("fk_security_group_permission_security_group");
        });

        modelBuilder.Entity<SecurityUserGroup>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_security_user_group");

            entity.HasOne(d => d.SecurityGroup).WithMany(p => p.SecurityUserGroups).HasConstraintName("fk_security_user_group_security_group");

            entity.HasOne(d => d.User).WithMany(p => p.SecurityUserGroups).HasConstraintName("fk_security_user_group_app_user");
        });

        modelBuilder.Entity<SettleType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_settle_type");
        });

        modelBuilder.Entity<SeveranceTax>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_severance_tax");

            entity.HasOne(d => d.LeaseType).WithMany(p => p.SeveranceTaxes)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_severance_tax_lease_type");

            entity.HasOne(d => d.State).WithMany(p => p.SeveranceTaxes)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_severance_tax_state");
        });

        modelBuilder.Entity<SosCrudePipeSetting>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_sos_crude_pipe_setting");

            entity.HasOne(d => d.Pipe).WithMany(p => p.SosCrudePipeSettings).HasConstraintName("fk_sos_crude_pipe_setting_pipeline");

            entity.HasOne(d => d.User).WithMany(p => p.SosCrudePipeSettings).HasConstraintName("fk_sos_crude_pipe_setting_app_user");
        });

        modelBuilder.Entity<SosCrudeSetting>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_sos_crude_setting");

            entity.HasOne(d => d.AutoSelectPipeline).WithMany(p => p.SosCrudeSettings)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_sos_crude_setting_pipeline");

            entity.HasOne(d => d.User).WithOne(p => p.SosCrudeSetting).HasConstraintName("fk_sos_crude_setting_app_user");
        });

        modelBuilder.Entity<SosGasPipeSetting>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_sos_gas_pipe_setting");

            entity.HasOne(d => d.Pipe).WithMany(p => p.SosGasPipeSettings).HasConstraintName("fk_sos_gas_pipe_setting_pipeline");

            entity.HasOne(d => d.User).WithMany(p => p.SosGasPipeSettings).HasConstraintName("fk_sos_pipe_setting_app_user");
        });

        modelBuilder.Entity<SosGasSetting>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_sos_gas_setting");

            entity.HasOne(d => d.AutoSelectPoint).WithMany(p => p.SosGasSettings)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_sos_gas_setting_point");

            entity.HasOne(d => d.User).WithOne(p => p.SosGasSetting).HasConstraintName("fk_sos_setting_app_user");
        });

        modelBuilder.Entity<SosHiddenDeal>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_sos_hidden_deal_hidden_rows");

            entity.HasOne(d => d.DeliveryPoint).WithMany(p => p.SosHiddenDealDeliveryPoints)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_sos_hidden_deal_point_1");

            entity.HasOne(d => d.ReceiptMeter).WithMany(p => p.SosHiddenDeals).HasConstraintName("fk_sos_hidden_deal_receipt_meter");

            entity.HasOne(d => d.ReceiptPoint).WithMany(p => p.SosHiddenDealReceiptPoints)
                .OnDelete(DeleteBehavior.Cascade)
                .HasConstraintName("fk_sos_hidden_deal_point");

            entity.HasOne(d => d.SupplyDeal).WithMany(p => p.SosHiddenDeals)
                .OnDelete(DeleteBehavior.Cascade)
                .HasConstraintName("fk_sos_hidden_deal_deal");

            entity.HasOne(d => d.TransferDeal).WithMany(p => p.SosHiddenDeals)
                .OnDelete(DeleteBehavior.Cascade)
                .HasConstraintName("fk_sos_hidden_deal_transfer_deal");
        });

        modelBuilder.Entity<SosSnapshot>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_sos_snapshot");

            entity.Property(e => e.CreatedTime).HasDefaultValueSql("CURRENT_TIMESTAMP");

            entity.HasOne(d => d.Pipe).WithMany(p => p.SosSnapshots)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_sos_snapshot_pipe");

            entity.HasOne(d => d.Point).WithMany(p => p.SosSnapshots).HasConstraintName("fk_sos_snapshot_point");
        });

        modelBuilder.Entity<StateIncomeExemption>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_state_income_exemption");

            entity.HasOne(d => d.Company).WithMany(p => p.StateIncomeExemptions).HasConstraintName("fk_state_income_exemption_company");

            entity.HasOne(d => d.State).WithMany(p => p.StateIncomeExemptions).HasConstraintName("fk_state_income_exemption_state");
        });

        modelBuilder.Entity<StateIncomeExemptionDoc>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_state_income_exemption_doc");

            entity.HasOne(d => d.StateIncomeExemption).WithMany(p => p.StateIncomeExemptionDocs).HasConstraintName("fk_state_income_exemption_doc_sales_tax_exemption");
        });

        modelBuilder.Entity<StorageFacility>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_storage_facility");
        });

        modelBuilder.Entity<Strategy>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_strategy");

            entity.Property(e => e.IsActive).HasDefaultValue(true);
        });

        modelBuilder.Entity<Template>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_template");
        });

        modelBuilder.Entity<Territory>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_territory");

            entity.Property(e => e.Id).ValueGeneratedNever();
        });

        modelBuilder.Entity<Ticket>(entity =>
        {
            entity.HasKey(e => e.TransactionTypeId).HasName("pk_ticket");

            entity.Property(e => e.TransactionTypeId).ValueGeneratedNever();
            entity.Property(e => e.TicketNumber).HasDefaultValue(0);
        });

        modelBuilder.Entity<TransactionType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_transaction_type");

            entity.Property(e => e.Id).ValueGeneratedNever();
        });

        modelBuilder.Entity<TransferDeal>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_transfer_deal");

            entity.HasIndex(e => new { e.StartDate, e.EndDate, e.Id, e.TransferMeterMapId, e.IsMeter1Supply }, "ix_transfer_deal").HasFilter("(path_id IS NOT NULL)");

            entity.Property(e => e.IsMeter1Supply).HasDefaultValue(true);

            entity.HasOne(d => d.CrudePath).WithMany(p => p.TransferDeals)
                .OnDelete(DeleteBehavior.Cascade)
                .HasConstraintName("fk_transfer_deal_crude_path");

            entity.HasOne(d => d.Path).WithMany(p => p.TransferDeals)
                .OnDelete(DeleteBehavior.Cascade)
                .HasConstraintName("fk_transfer_deal_path");

            entity.HasOne(d => d.TransferMeterMap).WithMany(p => p.TransferDeals).HasConstraintName("fk_transfer_deal_transfer_meter_map");
        });

        modelBuilder.Entity<TransferMeter>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_transfer_meter_map");

            entity.HasOne(d => d.Meter1).WithMany(p => p.TransferMeterMeter1s)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_transfer_meter_map_meter");

            entity.HasOne(d => d.Meter2).WithMany(p => p.TransferMeterMeter2s)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_transfer_meter_map_1");

            entity.HasOne(d => d.Product).WithMany(p => p.TransferMeters)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_transfer_meter_product");
        });

        modelBuilder.Entity<UnitOfMeasure>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_unit_of_measure");

            entity.Property(e => e.Id).ValueGeneratedNever();
        });

        modelBuilder.Entity<UnitOfMeasureConversion>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_unit_of_measure_conversion");

            entity.HasOne(d => d.FromUnitOfMeasure).WithMany(p => p.UnitOfMeasureConversions).HasConstraintName("fk_unit_of_measure_conversion_unit_of_measure");
        });

        modelBuilder.Entity<UnitPriceCombination>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_unit_price_combination");

            entity.HasOne(d => d.CurrencyType).WithMany(p => p.UnitPriceCombinations)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_unit_price_combination_currency_type");

            entity.HasOne(d => d.UnitOfMeasure).WithMany(p => p.UnitPriceCombinations).HasConstraintName("fk_unit_price_combination_unit_of_measure");
        });

        modelBuilder.Entity<UserScreenSort>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_user_screen_sort");

            entity.HasOne(d => d.Screen).WithMany(p => p.UserScreenSorts)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_user_screen_sort_screen");

            entity.HasOne(d => d.User).WithMany(p => p.UserScreenSorts).HasConstraintName("fk_user_screen_sort_app_user");
        });

        modelBuilder.Entity<VolumeType>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_volume_type");
        });

        modelBuilder.Entity<VwBrokerOverviewInfo>(entity =>
        {
            entity.ToView("vw_broker_overview_info");
        });

        modelBuilder.Entity<VwBusinessCalendar>(entity =>
        {
            entity.ToView("vw_business_calendar");
        });

        modelBuilder.Entity<VwBusinessTypeOverviewInfo>(entity =>
        {
            entity.ToView("vw_business_type_overview_info");
        });

        modelBuilder.Entity<VwContactOverviewInfo>(entity =>
        {
            entity.ToView("vw_contact_overview_info");
        });

        modelBuilder.Entity<VwCounterpartyOverviewInfo>(entity =>
        {
            entity.ToView("vw_counterparty_overview_info");
        });

        modelBuilder.Entity<VwCreditLimitCollateralOverview>(entity =>
        {
            entity.ToView("vw_credit_limit_collateral_overview");
        });

        modelBuilder.Entity<VwCrudePathFinalMeter>(entity =>
        {
            entity.ToView("vw_crude_path_final_meter");
        });

        modelBuilder.Entity<VwCrudePathingOverviewInfo>(entity =>
        {
            entity.ToView("vw_crude_pathing_overview_info");
        });

        modelBuilder.Entity<VwDealConfirmationInfo>(entity =>
        {
            entity.ToView("vw_deal_confirmation_info");
        });

        modelBuilder.Entity<VwDealOverviewInfo>(entity =>
        {
            entity.ToView("vw_deal_overview_info");
        });

        modelBuilder.Entity<VwGasPathFinalMeter>(entity =>
        {
            entity.ToView("vw_gas_path_final_meter");
        });

        modelBuilder.Entity<VwGasPathingOverviewInfo>(entity =>
        {
            entity.ToView("vw_gas_pathing_overview_info");
        });

        modelBuilder.Entity<VwIndexOverviewInfo>(entity =>
        {
            entity.ToView("vw_index_overview_info");
        });

        modelBuilder.Entity<VwInvoiceCrude>(entity =>
        {
            entity.ToView("vw_invoice_crude");
        });

        modelBuilder.Entity<VwInvoiceGa>(entity =>
        {
            entity.ToView("vw_invoice_gas");
        });

        modelBuilder.Entity<VwMeterOverviewInfo>(entity =>
        {
            entity.ToView("vw_meter_overview_info");
        });

        modelBuilder.Entity<VwMeterPointCrude>(entity =>
        {
            entity.ToView("vw_meter_point_crude");
        });

        modelBuilder.Entity<VwMeterPointGa>(entity =>
        {
            entity.ToView("vw_meter_point_gas");
        });

        modelBuilder.Entity<VwPaymentInstructionOverviewInfo>(entity =>
        {
            entity.ToView("vw_payment_instruction_overview_info");
        });

        modelBuilder.Entity<VwPipeContractOverviewInfo>(entity =>
        {
            entity.ToView("vw_pipe_contract_overview_info");
        });

        modelBuilder.Entity<VwPipeRateScheduleOverviewInfo>(entity =>
        {
            entity.ToView("vw_pipe_rate_schedule_overview_info");
        });

        modelBuilder.Entity<VwPipelineOverviewInfo>(entity =>
        {
            entity.ToView("vw_pipeline_overview_info");
        });

        modelBuilder.Entity<VwPlantStatementOverviewInfo>(entity =>
        {
            entity.ToView("vw_plant_statement_overview_info");
        });

        modelBuilder.Entity<VwPointOverviewInfo>(entity =>
        {
            entity.ToView("vw_point_overview_info");
        });

        modelBuilder.Entity<VwRptCounterparty>(entity =>
        {
            entity.ToView("vw_rpt_counterparty");
        });

        modelBuilder.Entity<VwRptCreditLimit>(entity =>
        {
            entity.ToView("vw_rpt_credit_limit");
        });

        modelBuilder.Entity<VwRptDailyIndexPrice>(entity =>
        {
            entity.ToView("vw_rpt_daily_index_price");
        });

        modelBuilder.Entity<VwRptDeal>(entity =>
        {
            entity.ToView("vw_rpt_deal");
        });

        modelBuilder.Entity<VwRptForwardIndexPrice>(entity =>
        {
            entity.ToView("vw_rpt_forward_index_price");
        });

        modelBuilder.Entity<VwRptMeterDatum>(entity =>
        {
            entity.ToView("vw_rpt_meter_data");
        });

        modelBuilder.Entity<VwRptMonthlyIndexPrice>(entity =>
        {
            entity.ToView("vw_rpt_monthly_index_price");
        });

        modelBuilder.Entity<VwRptPlantStatement>(entity =>
        {
            entity.ToView("vw_rpt_plant_statement");
        });

        modelBuilder.Entity<VwRptValuationDataDeal>(entity =>
        {
            entity.ToView("vw_rpt_valuation_data_deals");
        });

        modelBuilder.Entity<VwSalesTaxOverviewInfo>(entity =>
        {
            entity.ToView("vw_sales_tax_overview_info");
        });

        modelBuilder.Entity<VwSeveranceTaxOverviewInfo>(entity =>
        {
            entity.ToView("vw_severance_tax_overview_info");
        });

        modelBuilder.Entity<VwUserOverviewInfo>(entity =>
        {
            entity.ToView("vw_user_overview_info");
        });

        modelBuilder.Entity<VwValDeal>(entity =>
        {
            entity.ToView("vw_val_deal");
        });

        modelBuilder.Entity<VwValDealVolume>(entity =>
        {
            entity.ToView("vw_val_deal_volume");
        });

        modelBuilder.Entity<W9Form>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_w9_form");

            entity.HasOne(d => d.Counterparty).WithMany(p => p.W9FormCounterparties)
                .OnDelete(DeleteBehavior.Cascade)
                .HasConstraintName("fk_w9_form_counterparty");

            entity.HasOne(d => d.CounterpartyParent).WithMany(p => p.W9FormCounterpartyParents)
                .OnDelete(DeleteBehavior.ClientSetNull)
                .HasConstraintName("fk_w9_form_counterparty_parent");
        });

        modelBuilder.Entity<W9FormDoc>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_w9_form_doc");

            entity.HasOne(d => d.W9Form).WithMany(p => p.W9FormDocs).HasConstraintName("fk_w9_form_doc");
        });

        modelBuilder.Entity<Zone>(entity =>
        {
            entity.HasKey(e => e.Id).HasName("pk_zone");

            entity.HasOne(d => d.Pipeline).WithMany(p => p.Zones).HasConstraintName("fk_zone_pipeline");
        });

        OnModelCreatingPartial(modelBuilder);
    }

    partial void OnModelCreatingPartial(ModelBuilder modelBuilder);
}
