#!/usr/bin/env bash
set -euo pipefail

# Prefer Flatpak Chrome if installed, else fall back to system Chrome/Chromium.
if [ -x "$HOME/.local/share/flatpak/exports/bin/com.google.Chrome" ]; then
  exec "$HOME/.local/share/flatpak/exports/bin/com.google.Chrome" "$@"
elif [ -x "/var/lib/flatpak/exports/bin/com.google.Chrome" ]; then
  exec "/var/lib/flatpak/exports/bin/com.google.Chrome" "$@"
elif command -v google-chrome-stable >/dev/null 2>&1; then
  exec google-chrome-stable "$@"
elif command -v google-chrome >/dev/null 2>&1; then
  exec google-chrome "$@"
elif command -v chromium >/dev/null 2>&1; then
  exec chromium "$@"
elif command -v chromium-browser >/dev/null 2>&1; then
  exec chromium-browser "$@"
else
  echo "No Chrome/Chromium found. Install Google Chrome/Chromium or Flatpak com.google.Chrome" >&2
  exit 1
fi