namespace Fast.Web.Controllers;

[Authorize]
[ApiController]
[Route("api/[controller]")]
public class DashController : ODataController
{
    private readonly MyDbContext db;

    public DashController(MyDbContext context)
    {
        db = context;
    }

    [Route("[action]")]
    public async Task<IActionResult> GetUserScreenSorts()
    {
        var appUserId = Util.GetAppUserId(User);
        var screenSorts = await db.UserScreenSorts.Where(x => x.UserId == appUserId).Select(x => new
        {
            x.ScreenId,
            x.OrderId,
            ModuleName = x.Screen.Parent != null && x.Screen.Parent.Name != null ? x.Screen.Parent.Name.ToLower() : ""
        }).ToListAsync();

        return Ok(screenSorts);
    }

    [Route("[action]")]
    public async Task<IActionResult> SaveScreenSort(List<int> orderedScreenIds)
    {
        var appUserId = Util.GetAppUserId(User);

        var parentId = (await db.Screens.FindAsync(orderedScreenIds.First()))?.ParentId;
        if (!parentId.HasValue)
            return Ok();

        //delete existing screen sorts
        var screenSorts = await db.UserScreenSorts.Where(x => x.UserId == appUserId && x.Screen.ParentId == parentId).ToListAsync();
        if (screenSorts.Any())
            db.UserScreenSorts.RemoveRange(screenSorts);

        //recreate and insert screen sorts
        var screenSortList = new List<UserScreenSort>();
        foreach (var screenId in orderedScreenIds)
        {
            screenSortList.Add(new UserScreenSort
            {
                UserId = appUserId,
                ScreenId = screenId,
                OrderId = orderedScreenIds.IndexOf(screenId) + 1
            });
        }
        db.UserScreenSorts.AddRange(screenSortList);
        await db.SaveChangesAsync();

        var userScreenSorts = await db.UserScreenSorts.Where(x => x.UserId == appUserId).Select(x => new
        {
            x.ScreenId,
            x.OrderId,
            ModuleName = x.Screen.Parent != null && x.Screen.Parent.Name != null ? x.Screen.Parent.Name.ToLower() : ""
        }).ToListAsync();

        return Ok(userScreenSorts);
    }
}
