import { Pipe, PipeTransform } from '@angular/core';
import { ModuleMenu } from '../_shared/services/common.service';

@Pipe({
  name: 'hasModule',
  standalone: true
})
export class HasModulePipe implements PipeTransform {
  transform(moduleName: string, moduleMenus: ModuleMenu[]): boolean {
    const hasModule = moduleMenus.some(x => x.name.toLowerCase() === moduleName.toLowerCase());
    return hasModule;
  }
}
