import { inject, Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { OdataGridHelper } from '../_shared/utils/odata-grid-helper';
import { Observable } from 'rxjs';

export interface UserScreenSort {
  screenId: number;
  orderId: number;
  moduleName: string;
}

@Injectable({
  providedIn: 'root'
})
export class DashService extends OdataGridHelper {
  readonly baseUrl = `${window.location.origin}/api/Dash`;
  http = inject(HttpClient)

  getUserScreenSort(): Observable<UserScreenSort[]> {
    const url = `${this.baseUrl}/GetUserScreenSorts`;
    return this.http.get<UserScreenSort[]>(url);
  }

  saveScreenSort(orderedScreenIds: number[]): Observable<UserScreenSort[]> {
    const url = `${this.baseUrl}/SaveScreenSort`;
    return this.http.put<UserScreenSort[]>(url, orderedScreenIds);
  }
}
