import { AuthClass } from "./authClass";

export function appInit(): Promise<void> {
  return new Promise((resolve, reject) => {
    const oReq = new XMLHttpRequest();
    oReq.addEventListener('load', () => {
      if (oReq.status === 200) {
        try {
          AuthClass.ServerSettings = JSON.parse(oReq.responseText);
          AuthClass.ServerSettings.mainSiteUrl = window.location.protocol + "//" + window.location.host;
        } catch (e) {
          reject(e);
        }
        resolve();
      } else {
        reject(oReq.statusText);
      }
    });
    oReq.open('GET', 'api/Common/GetServerSettings');
    oReq.send();
  });
}