import { ChangeDetectionStrategy, Component, computed, input, output } from '@angular/core';
import { FAST_KENDO_COMMON } from '../../app.config';
import { ControlValueAccessor, NG_VALUE_ACCESSOR } from '@angular/forms';
import { NumberFormatOptions } from '@progress/kendo-angular-intl';

@Component({
  selector: 'fast-numerictextbox',
  changeDetection: ChangeDetectionStrategy.OnPush,
  imports: [FAST_KENDO_COMMON],
  providers: [{
    provide: NG_VALUE_ACCESSOR,
    multi: true,
    useExisting: FastNumericTextBoxComponent
  }],
  template: `
  <kendo-numerictextbox
  class="flex border-2 border-solid rounded-sm h-7.5 [&_button]:border-none
  [&_button]:w-5.5"
  [min]="min()"
  [max]="max()"
  [class]="conditionalClasses()"
  [autoCorrect]="autoCorrect()"
  [format]="format()"
  [spinners]="spinners()"
  [step]="step()"
  [tabindex]="tabindex()"
  [value]="value"
  (valueChange)="onValueChange($event)"
  >
  </kendo-numerictextbox>
  `
})
export class FastNumericTextBoxComponent implements ControlValueAccessor {
  min = input<number | null>(null);
  max = input<number | null>(null);
  tabindex = input<number>(0);
  spinners = input<boolean>(true);
  step = input<number>(1);
  autoCorrect = input<boolean>(false);
  valueChange = output<number | null>();
  format = input<string | NumberFormatOptions>();

  value: number | null = null;
  // eslint-disable-next-line @typescript-eslint/no-unused-vars
  onChange = (_: number) => { };
  onTouched = () => { };

  writeValue(obj: number): void {
    this.value = obj;
  }

  registerOnChange(fn: () => void) {
    this.onChange = fn;
  }

  registerOnTouched(fn: () => void) {
    this.onTouched = fn;
  }

  onValueChange(event: number): void {
    this.value = event;
    this.onChange(this.value); // Notify the Forms API about the change
    this.valueChange.emit(event);
  }

  conditionalClasses = computed(() => {
    const classes = [] as string[];

    classes.push(...this.getLightBaseClasses());
    classes.push(...this.getDarkBaseClasses());
    classes.push(...this.getLightActiveClasses());
    classes.push(...this.getDarkActiveClasses());

    const conditionalClasses = this.getConditionalClassesFromArrays(classes);
    return conditionalClasses;
  });

  getConditionalClassesFromArrays(classArray: string[]): { [key: string]: boolean } {
    const classes: { [key: string]: boolean } = {};
    classArray.forEach(className => {
      classes[className] = true;
    });
    return classes;
  }

  getLightBaseClasses() {
    return [
      "[&_button]:text-black",
      "[&_button]:bg-base-white-250"];
  }

  getDarkBaseClasses() {
    return [
      "dark:[&_button]:text-white",
      "dark:[&_button]:bg-alt-gray-1000"];
  }

  getLightActiveClasses() {
    return [
      "[&_button]:active:bg-base-white-1000"];
  }

  getDarkActiveClasses() {
    return [
      "dark:[&_button]:active:bg-alt-blue-250"];
  }
}
