import { ChangeDetectionStrategy, Component, inject, OnInit } from "@angular/core";
import { RouteHistoryService } from "./services/route-history.service";
import { Router } from "@angular/router";
import { defaultRoute } from "../app.routes";

@Component({
  changeDetection: ChangeDetectionStrategy.OnPush,
  template: ''
})
export class DefaultRouteRedirectComponent implements OnInit {
  router = inject(Router);
  routeHistoryService = inject(RouteHistoryService);

  ngOnInit() {
    const currentUrl = this.router.url;
    const lastRoute = this.routeHistoryService.hasLastRoute()
      ? this.routeHistoryService.getLastRoute()
      : defaultRoute;

    if (currentUrl !== lastRoute)
      this.router.navigateByUrl(lastRoute);
  }
}
