using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("user_screen_sort")]
[Index("UserId", "ScreenId", Name = "uk_user_screen_sort", IsUnique = true)]
public partial class UserScreenSort
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("user_id")]
    public int UserId { get; set; }

    [Column("screen_id")]
    public int ScreenId { get; set; }

    [Column("order_id")]
    public int OrderId { get; set; }

    [ForeignKey("ScreenId")]
    [InverseProperty("UserScreenSorts")]
    public virtual Screen Screen { get; set; } = null!;

    [ForeignKey("UserId")]
    [InverseProperty("UserScreenSorts")]
    public virtual AppUser User { get; set; } = null!;
}
