using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("strategy")]
[Index("Name", Name = "uk_strategy", IsUnique = true)]
public partial class Strategy
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string? Name { get; set; }

    [Column("is_active")]
    public bool IsActive { get; set; }

    [InverseProperty("Strategy")]
    public virtual ICollection<Deal> Deals { get; set; } = new List<Deal>();
}
