using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("sales_tax_exemption_doc")]
[Index("SalesTaxExemptionId", "FileNameOnDisk", Name = "uk_sales_tax_exemption_doc", IsUnique = true)]
public partial class SalesTaxExemptionDoc
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("sales_tax_exemption_id")]
    public int SalesTaxExemptionId { get; set; }

    [Column("file_name_original", TypeName = "citext")]
    public string FileNameOriginal { get; set; } = null!;

    [Column("file_name_on_disk", TypeName = "citext")]
    public string FileNameOnDisk { get; set; } = null!;

    [ForeignKey("SalesTaxExemptionId")]
    [InverseProperty("SalesTaxExemptionDocs")]
    public virtual SalesTaxExemption SalesTaxExemption { get; set; } = null!;
}
