using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("pipeline_contract_type")]
public partial class PipelineContractType
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("name", TypeName = "citext")]
    public string Name { get; set; } = null!;

    [InverseProperty("ContractType")]
    public virtual ICollection<PipelineContract> PipelineContracts { get; set; } = new List<PipelineContract>();

    [InverseProperty("ContractTypeNavigation")]
    public virtual ICollection<PipelineRateSchedule> PipelineRateSchedules { get; set; } = new List<PipelineRateSchedule>();
}
