using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("pipe_contract_receipt_zone")]
[Index("PipeContractId", "ZoneId", Name = "uk_pipe_contract_receipt_zone", IsUnique = true)]
public partial class PipeContractReceiptZone
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("pipe_contract_id")]
    public int PipeContractId { get; set; }

    [Column("zone_id")]
    public int ZoneId { get; set; }

    [ForeignKey("PipeContractId")]
    [InverseProperty("PipeContractReceiptZones")]
    public virtual PipelineContract PipeContract { get; set; } = null!;

    [ForeignKey("ZoneId")]
    [InverseProperty("PipeContractReceiptZones")]
    public virtual Zone Zone { get; set; } = null!;
}
