using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;
using Microsoft.EntityFrameworkCore;

namespace Fast.Database.Models;

[Table("meter_ptr")]
public partial class MeterPtr
{
    [Key]
    [Column("id")]
    public int Id { get; set; }

    [Column("meter_id")]
    public int MeterId { get; set; }

    [Column("ptr")]
    public double Ptr { get; set; }

    [Column("effective_date")]
    public DateOnly EffectiveDate { get; set; }

    [Column("data_date")]
    public DateOnly DataDate { get; set; }

    [ForeignKey("MeterId")]
    [InverseProperty("MeterPtrs")]
    public virtual Meter Meter { get; set; } = null!;

    [InverseProperty("MeterPtr")]
    public virtual ICollection<MeterPtrExcluded> MeterPtrExcludeds { get; set; } = new List<MeterPtrExcluded>();
}
